/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.AbstractFloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractFloatList
extends AbstractFloatCollection
implements FloatList,
FloatStack {
    private static final boolean ASSERTS = false;

    protected AbstractFloatList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public void add(int index, float k) {
        throw new UnsupportedOperationException();
    }

    public boolean add(float k) {
        this.add(this.size(), k);
        return true;
    }

    public boolean rem(float k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeFloat(index);
        return true;
    }

    public float removeFloat(int i) {
        throw new UnsupportedOperationException();
    }

    public float set(int index, float k) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, FloatCollection c) {
        return this.addAll(index, (Collection)c);
    }

    public boolean addAll(int index, FloatList l) {
        return this.addAll(index, (FloatCollection)l);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(FloatCollection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(FloatList l) {
        return this.addAll(this.size(), l);
    }

    public ListIterator listIterator() {
        return this.floatListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.floatListIterator(index);
    }

    public FloatIterator floatIterator() {
        return this.floatListIterator();
    }

    public FloatListIterator floatListIterator() {
        return this.floatListIterator(0);
    }

    public FloatListIterator floatListIterator(final int index) {
        return new AbstractFloatListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractFloatList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractFloatList.this.getFloat(this.last);
            }

            public float previousFloat() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractFloatList.this.getFloat(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(float k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractFloatList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(float k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractFloatList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractFloatList.this.removeFloat(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public boolean contains(float k) {
        return this.indexOf(k) >= 0;
    }

    public int indexOf(float k) {
        FloatListIterator i = this.floatListIterator();
        while (i.hasNext()) {
            float e = i.nextFloat();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public int lastIndexOf(float k) {
        FloatListIterator i = this.floatListIterator(this.size());
        while (i.hasPrevious()) {
            float e = i.previousFloat();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public void size(int size) {
        int i = this.size();
        if (size > i) {
            while (i++ < size) {
                this.add(0.0f);
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public FloatList floatSubList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new FloatSubList(this, from, to);
    }

    public List subList(int from, int to) {
        return this.floatSubList(from, to);
    }

    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        FloatListIterator i = this.floatListIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextFloat();
            i.remove();
        }
    }

    public void addElements(int index, float[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a[offset++]);
        }
    }

    public void addElements(int index, float[] a) {
        this.addElements(index, a, 0, a.length);
    }

    public void getElements(int from, float[] a, int offset, int length) {
        FloatListIterator i = this.floatListIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextFloat();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof FloatList) {
            FloatList l = (FloatList)o;
            FloatListIterator i1 = this.floatListIterator();
            FloatListIterator i2 = l.floatListIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                float e2;
                float e1 = i1.nextFloat();
                if ((e1 < (e2 = i2.nextFloat()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        List l = (List)o;
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    public int hashCode() {
        FloatIterator i = this.floatIterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            float k = i.nextFloat();
            h = 31 * h + HashCommon.float2int(k);
        }
        return h;
    }

    public void push(float o) {
        this.add(o);
    }

    public float popFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeFloat(this.size() - 1);
    }

    public float topFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFloat(this.size() - 1);
    }

    public float peekFloat(int i) {
        return this.getFloat(this.size() - 1 - i);
    }

    public void add(int index, Object ok) {
        this.add(index, ((Float)ok).floatValue());
    }

    public Object set(int index, Object ok) {
        return new Float(this.set(index, ((Float)ok).floatValue()));
    }

    public Object get(int index) {
        return new Float(this.getFloat(index));
    }

    public int indexOf(Object ok) {
        return this.indexOf(((Float)ok).floatValue());
    }

    public int lastIndexOf(Object ok) {
        return this.lastIndexOf(((Float)ok).floatValue());
    }

    public Object remove(int index) {
        return new Float(this.removeFloat(index));
    }

    public void push(Object o) {
        this.push(((Float)o).floatValue());
    }

    public Object pop() {
        return new Float(this.popFloat());
    }

    public Object top() {
        return new Float(this.topFloat());
    }

    public Object peek(int i) {
        return new Float(this.peekFloat(i));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        FloatIterator i = this.floatIterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            float k = i.nextFloat();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class FloatSubList
    extends AbstractFloatList
    implements Serializable {
        protected final FloatList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public FloatSubList(FloatList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(float k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, float k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        public boolean addAll(int index, Collection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, FloatCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, FloatList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }

        public float getFloat(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getFloat(this.from + index);
        }

        public float removeFloat(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeFloat(this.from + index);
        }

        public boolean rem(float k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeFloat(this.from + index);
            return true;
        }

        public float set(int index, float k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public int size() {
            return this.to - this.from;
        }

        public void getElements(int from, float[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        public void addElements(int index, float[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        public FloatListIterator floatListIterator(int index) {
            this.ensureIndex(index);
            return new AbstractFloatListIterator(this, index){
                int pos;
                int last;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ FloatSubList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.pos = this.val$index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < this.this$0.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public float nextFloat() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return this.this$0.l.getFloat(this.this$0.from + this.last);
                }

                public float previousFloat() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return this.this$0.l.getFloat(this.this$0.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(float k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.add(this.pos++, k);
                    this.last = -1;
                }

                public void set(float k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.removeFloat(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        public FloatList floatSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new FloatSubList(this, from, to);
        }
    }
}

