/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractFloatCollection
implements FloatCollection {
    protected AbstractFloatCollection() {
    }

    public float[] toArray(float[] a) {
        return this.toFloatArray(a);
    }

    public float[] toFloatArray() {
        return this.toFloatArray(null);
    }

    public float[] toFloatArray(float[] a) {
        if (a == null || a.length < this.size()) {
            a = new float[this.size()];
        }
        FloatIterators.unwrap(this.floatIterator(), a);
        return a;
    }

    public boolean addAll(FloatCollection c) {
        boolean retVal = false;
        FloatIterator i = c.floatIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextFloat())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(FloatCollection c) {
        FloatIterator i = c.floatIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextFloat())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(FloatCollection c) {
        boolean retVal = false;
        int n = this.size();
        FloatIterator i = this.floatIterator();
        while (n-- != 0) {
            if (c.contains(i.nextFloat())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(FloatCollection c) {
        boolean retVal = false;
        int n = c.size();
        FloatIterator i = c.floatIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextFloat())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.floatIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(float k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(float k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem(((Float)ok).floatValue());
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.floatIterator();
    }

    public boolean add(Object o) {
        return this.add(((Float)o).floatValue());
    }

    public boolean rem(Object o) {
        return this.rem(((Float)o).floatValue());
    }

    public boolean contains(Object o) {
        return this.contains(((Float)o).floatValue());
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        FloatIterator i = this.floatIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            float k = i.nextFloat();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

