/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2ReferenceMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFloat2ReferenceMap
implements Float2ReferenceMap,
Serializable {
    protected Object defRetValue;

    protected AbstractFloat2ReferenceMap() {
    }

    public void setDefRetValue(Object rv) {
        this.defaultReturnValue(rv);
    }

    public Object getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(Object rv) {
        this.defRetValue = rv;
    }

    public Object defaultReturnValue() {
        return this.defRetValue;
    }

    public Object put(float key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(float key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        float k = ((Float)ok).floatValue();
        return this.containsKey(k) ? this.get(k) : null;
    }

    public Object put(Object ok, Object ov) {
        float k = ((Float)ok).floatValue();
        Object v = this.put(k, ov);
        return this.containsKey(k) ? v : null;
    }

    public Object remove(Object ok) {
        float k = ((Float)ok).floatValue();
        Object v = this.remove(k);
        return this.containsKey(k) ? v : null;
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Float)ok).floatValue());
    }

    public boolean containsValue(Object v) {
        return ((ReferenceCollection)this.values()).contains(v);
    }

    public boolean containsKey(float k) {
        return ((FloatSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Float2ReferenceMap) {
            while (n-- != 0) {
                Float2ReferenceMap.Entry e = (Float2ReferenceMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractFloatSet(){

            public boolean contains(float k) {
                return AbstractFloat2ReferenceMap.this.containsKey(k);
            }

            public int size() {
                return AbstractFloat2ReferenceMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Float2ReferenceMap.Entry)this.i.next()).getFloatKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractFloat2ReferenceMap access$000(1 x0) {
                return x0.AbstractFloat2ReferenceMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractReferenceCollection(){

            public boolean contains(Object k) {
                return AbstractFloat2ReferenceMap.this.containsValue(k);
            }

            public int size() {
                return AbstractFloat2ReferenceMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public Object next() {
                        return ((Float2ReferenceMap.Entry)this.i.next()).getValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractFloat2ReferenceMap access$100(3 x0) {
                return x0.AbstractFloat2ReferenceMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2ReferenceMap.Entry e = (Float2ReferenceMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Float2ReferenceMap.Entry {
        protected float key;
        protected Object value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Float)key).floatValue();
            this.value = value;
        }

        public BasicEntry(float key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Float(this.key);
        }

        public float getFloatKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Float)e.getKey()).floatValue() && this.value == e.getValue();
        }

        public int hashCode() {
            return HashCommon.float2int(this.key) ^ System.identityHashCode(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

