/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFloat2LongMap
implements Float2LongMap,
Serializable {
    protected long defRetValue;

    protected AbstractFloat2LongMap() {
    }

    public void setDefRetValue(long rv) {
        this.defaultReturnValue(rv);
    }

    public long getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(long rv) {
        this.defRetValue = rv;
    }

    public long defaultReturnValue() {
        return this.defRetValue;
    }

    public long put(float key, long value) {
        throw new UnsupportedOperationException();
    }

    public long remove(float key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        float k = ((Float)ok).floatValue();
        return this.containsKey(k) ? new Long(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        float k = ((Float)ok).floatValue();
        long v = this.put(k, (Long)ov);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public Object remove(Object ok) {
        float k = ((Float)ok).floatValue();
        long v = this.remove(k);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Long)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Float)ok).floatValue());
    }

    public boolean containsValue(long v) {
        return ((LongCollection)this.values()).contains(v);
    }

    public boolean containsKey(float k) {
        return ((FloatSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Float2LongMap) {
            while (n-- != 0) {
                Float2LongMap.Entry e = (Float2LongMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getLongValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractFloatSet(){

            public boolean contains(float k) {
                return AbstractFloat2LongMap.this.containsKey(k);
            }

            public int size() {
                return AbstractFloat2LongMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Float2LongMap.Entry)this.i.next()).getFloatKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractFloat2LongMap access$000(1 x0) {
                return x0.AbstractFloat2LongMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractLongCollection(){

            public boolean contains(long k) {
                return AbstractFloat2LongMap.this.containsValue(k);
            }

            public int size() {
                return AbstractFloat2LongMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Float2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractFloat2LongMap access$100(3 x0) {
                return x0.AbstractFloat2LongMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2LongMap.Entry e = (Float2LongMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            s.append(String.valueOf(e.getLongValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Float2LongMap.Entry {
        protected float key;
        protected long value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Float)key).floatValue();
            this.value = (Long)value;
        }

        public BasicEntry(float key, long value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Float(this.key);
        }

        public float getFloatKey() {
            return this.key;
        }

        public Object getValue() {
            return new Long(this.value);
        }

        public long getLongValue() {
            return this.value;
        }

        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Long(this.setValue((Long)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Float)e.getKey()).floatValue() && this.value == (Long)e.getValue();
        }

        public int hashCode() {
            return HashCommon.float2int(this.key) ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

