/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2CharMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFloat2CharMap
implements Float2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractFloat2CharMap() {
    }

    public void setDefRetValue(char rv) {
        this.defaultReturnValue(rv);
    }

    public char getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    public char defaultReturnValue() {
        return this.defRetValue;
    }

    public char put(float key, char value) {
        throw new UnsupportedOperationException();
    }

    public char remove(float key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        float k = ((Float)ok).floatValue();
        return this.containsKey(k) ? new Character(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        float k = ((Float)ok).floatValue();
        char v = this.put(k, ((Character)ov).charValue());
        return this.containsKey(k) ? new Character(v) : null;
    }

    public Object remove(Object ok) {
        float k = ((Float)ok).floatValue();
        char v = this.remove(k);
        return this.containsKey(k) ? new Character(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Float)ok).floatValue());
    }

    public boolean containsValue(char v) {
        return ((CharCollection)this.values()).contains(v);
    }

    public boolean containsKey(float k) {
        return ((FloatSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Float2CharMap) {
            while (n-- != 0) {
                Float2CharMap.Entry e = (Float2CharMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractFloatSet(){

            public boolean contains(float k) {
                return AbstractFloat2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Float2CharMap.Entry)this.i.next()).getFloatKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractFloat2CharMap access$000(1 x0) {
                return x0.AbstractFloat2CharMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractFloat2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Float2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractFloat2CharMap access$100(3 x0) {
                return x0.AbstractFloat2CharMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2CharMap.Entry e = (Float2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Float2CharMap.Entry {
        protected float key;
        protected char value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Float)key).floatValue();
            this.value = ((Character)value).charValue();
        }

        public BasicEntry(float key, char value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Float(this.key);
        }

        public float getFloatKey() {
            return this.key;
        }

        public Object getValue() {
            return new Character(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Character(this.setValue(((Character)value).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Float)e.getKey()).floatValue() && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return HashCommon.float2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

