/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleSets;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class DoubleSortedSets {
    private DoubleSortedSets() {
    }

    public static DoubleSortedSet singleton(double element) {
        return new Singleton(element);
    }

    public static DoubleSortedSet singleton(double element, DoubleComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static DoubleSortedSet singleton(Object element) {
        return new Singleton((double)((Double)element));
    }

    public static DoubleSortedSet singleton(Object element, DoubleComparator comparator) {
        return new Singleton((Double)element, comparator);
    }

    public static DoubleSortedSet synchronize(DoubleSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static DoubleSortedSet synchronize(DoubleSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static DoubleSortedSet unmodifiable(DoubleSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends DoubleSets.UnmodifiableSet
    implements DoubleSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleSortedSet sortedSet;

        protected UnmodifiableSortedSet(DoubleSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public DoubleSortedSet subSet(double from, double to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public DoubleSortedSet headSet(double to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public DoubleSortedSet tailSet(double from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public DoubleBidirectionalIterator iterator(double from) {
            return DoubleIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        public double firstDouble() {
            return this.sortedSet.firstDouble();
        }

        public double lastDouble() {
            return this.sortedSet.lastDouble();
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }

        public Iterator iterator(Object from) {
            return DoubleIterators.unmodifiable(this.sortedSet.iterator((Double)from));
        }

        public SortedSet subSet(Object from, Object to) {
            return new UnmodifiableSortedSet((DoubleSortedSet)this.sortedSet.subSet(from, to));
        }

        public SortedSet headSet(Object to) {
            return new UnmodifiableSortedSet((DoubleSortedSet)this.sortedSet.headSet(to));
        }

        public SortedSet tailSet(Object from) {
            return new UnmodifiableSortedSet((DoubleSortedSet)this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends DoubleSets.SynchronizedSet
    implements DoubleSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleSortedSet sortedSet;

        protected SynchronizedSortedSet(DoubleSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(DoubleSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public DoubleSortedSet subSet(double from, double to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public DoubleSortedSet headSet(double to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public DoubleSortedSet tailSet(double from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public DoubleBidirectionalIterator iterator(double from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double firstDouble() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstDouble();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double lastDouble() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastDouble();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        public Iterator iterator(Object from) {
            return this.sortedSet.iterator((Double)from);
        }

        public SortedSet subSet(Object from, Object to) {
            return new SynchronizedSortedSet((DoubleSortedSet)this.sortedSet.subSet(from, to), this.sync);
        }

        public SortedSet headSet(Object to) {
            return new SynchronizedSortedSet((DoubleSortedSet)this.sortedSet.headSet(to), this.sync);
        }

        public SortedSet tailSet(Object from) {
            return new SynchronizedSortedSet((DoubleSortedSet)this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends DoubleSets.Singleton
    implements DoubleSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final DoubleComparator comparator;

        private Singleton(double element, DoubleComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(double element) {
            this(element, (DoubleComparator)null);
        }

        final int compare(double k1, double k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public DoubleBidirectionalIterator iterator(double from) {
            DoubleBidirectionalIterator i = (DoubleBidirectionalIterator)this.doubleIterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public DoubleSortedSet subSet(double from, double to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public DoubleSortedSet headSet(double to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public DoubleSortedSet tailSet(double from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public double firstDouble() {
            return this.element;
        }

        public double lastDouble() {
            return this.element;
        }

        public Object first() {
            return new Double(this.element);
        }

        public Object last() {
            return new Double(this.element);
        }

        public Iterator iterator(Object from) {
            return this.iterator((Double)from);
        }

        public SortedSet subSet(Object from, Object to) {
            return this.subSet((Double)from, (Double)to);
        }

        public SortedSet headSet(Object to) {
            return this.headSet((Double)to);
        }

        public SortedSet tailSet(Object from) {
            return this.tailSet((Double)from);
        }
    }
}

