/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Lists;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollections;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class DoubleLists {
    private DoubleLists() {
    }

    public static DoubleList singleton(double element) {
        return new Singleton(element);
    }

    public static DoubleList singleton(Object element) {
        return new Singleton((Double)element);
    }

    public static DoubleList synchronize(DoubleList l) {
        return new SynchronizedList(l);
    }

    public static DoubleList synchronize(DoubleList l, Object sync) {
        return new SynchronizedList(l, sync);
    }

    public static DoubleList unmodifiable(DoubleList l) {
        return new UnmodifiableList(l);
    }

    public static class UnmodifiableList
    extends DoubleCollections.UnmodifiableCollection
    implements DoubleList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList list;

        protected UnmodifiableList(DoubleList l) {
            super(l);
            this.list = l;
        }

        public double getDouble(int i) {
            return this.list.getDouble(i);
        }

        public double set(int i, double k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, double k) {
            throw new UnsupportedOperationException();
        }

        public double removeDouble(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(double k) {
            return this.list.indexOf(k);
        }

        public int lastIndexOf(double k) {
            return this.list.lastIndexOf(k);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, DoubleList l) {
            throw new UnsupportedOperationException();
        }

        public void getElements(int from, double[] a, int offset, int length) {
            this.list.getElements(from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, double[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, double[] a) {
            throw new UnsupportedOperationException();
        }

        public void size(int size) {
            this.list.size(size);
        }

        public ListIterator listIterator() {
            return DoubleIterators.unmodifiable((DoubleListIterator)this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return DoubleIterators.unmodifiable((DoubleListIterator)this.list.listIterator(i));
        }

        public DoubleListIterator doubleListIterator() {
            return DoubleIterators.unmodifiable(this.list.doubleListIterator());
        }

        public DoubleListIterator doubleListIterator(int i) {
            return DoubleIterators.unmodifiable(this.list.doubleListIterator(i));
        }

        public List subList(int from, int to) {
            return new UnmodifiableList((DoubleList)this.list.subList(from, to));
        }

        public DoubleList doubleSubList(int from, int to) {
            return new UnmodifiableList(this.list.doubleSubList(from, to));
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public int compareTo(Object o) {
            return this.list.compareTo(o);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class SynchronizedList
    extends DoubleCollections.SynchronizedCollection
    implements DoubleList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList list;

        protected SynchronizedList(DoubleList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedList(DoubleList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getDouble(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getDouble(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double set(int i, double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, double k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double removeDouble(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeDouble(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, DoubleCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(DoubleList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, DoubleList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getElements(int from, double[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, double[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, double[] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.list.listIterator(i);
        }

        public DoubleListIterator doubleListIterator() {
            return this.list.doubleListIterator();
        }

        public DoubleListIterator doubleListIterator(int i) {
            return this.list.doubleListIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList((DoubleList)this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DoubleList doubleSubList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.doubleSubList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int compareTo(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }
    }

    public static class Singleton
    extends AbstractDoubleList
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        private final double element;

        private Singleton(double element) {
            this.element = element;
        }

        public boolean rem(double k) {
            throw new UnsupportedOperationException();
        }

        public boolean add(double k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, double k) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int i) {
            if (i == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public double removeDouble(int i) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(double k) {
            return k == this.element;
        }

        public boolean addAll(DoubleList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, DoubleList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public double[] toDoubleArray() {
            double[] a = new double[]{this.element};
            return a;
        }

        public DoubleListIterator doubleListIterator() {
            return DoubleIterators.wrap(this.toDoubleArray());
        }

        public DoubleListIterator doubleListIterator(int i) {
            if (i > 1 || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            DoubleListIterator l = DoubleIterators.wrap(this.toDoubleArray());
            if (i == 1) {
                l.next();
            }
            return l;
        }

        public DoubleList doubleSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return Lists.EMPTY_LIST;
            }
            return this;
        }

        public int size() {
            return 1;
        }

        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }
}

