/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class DoubleIterators {
    private DoubleIterators() {
    }

    public static DoubleListIterator emptyDoubleIterator() {
        return Iterators.EMPTY_ITERATOR;
    }

    public static DoubleListIterator wrap(double[] array, int offset, int length) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static DoubleListIterator wrap(double[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(DoubleIterator i, double[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.nextDouble();
        }
        return max - j - 1;
    }

    public static int unwrap(DoubleIterator i, double[] array) {
        return DoubleIterators.unwrap(i, array, 0, array.length);
    }

    public static double[] unwrap(DoubleIterator i, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        double[] array = new double[16];
        int j = 0;
        while (max-- != 0 && i.hasNext()) {
            if (j == array.length) {
                array = DoubleArrays.grow(array, j + 1);
            }
            array[j++] = i.nextDouble();
        }
        return DoubleArrays.trim(array, j);
    }

    public static double[] unwrap(DoubleIterator i) {
        return DoubleIterators.unwrap(i, Integer.MAX_VALUE);
    }

    public static int unwrap(DoubleIterator i, DoubleCollection c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            c.add(i.nextDouble());
        }
        return max - j - 1;
    }

    public static long unwrap(DoubleIterator i, DoubleCollection c) {
        long n = 0L;
        while (i.hasNext()) {
            c.add(i.nextDouble());
            ++n;
        }
        return n;
    }

    public static int pour(DoubleIterator i, DoubleCollection s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            s.add(i.nextDouble());
        }
        return max - j - 1;
    }

    public static int pour(DoubleIterator i, DoubleCollection s) {
        return DoubleIterators.pour(i, s, Integer.MAX_VALUE);
    }

    public static DoubleList pour(DoubleIterator i, int max) {
        DoubleArrayList l = new DoubleArrayList();
        DoubleIterators.pour(i, l, max);
        l.trim();
        return l;
    }

    public static DoubleList pour(DoubleIterator i) {
        return DoubleIterators.pour(i, Integer.MAX_VALUE);
    }

    public static DoubleListIterator asDoubleIterator(ListIterator i) {
        if (i instanceof DoubleListIterator) {
            return (DoubleListIterator)i;
        }
        return new ListIteratorWrapper(i);
    }

    public static DoubleIterator asDoubleIterator(Iterator i) {
        if (i instanceof DoubleIterator) {
            return (DoubleIterator)i;
        }
        return new IteratorWrapper(i);
    }

    public static DoubleIterator concat(DoubleIterator[] a) {
        return DoubleIterators.concat(a, 0, a.length);
    }

    public static DoubleIterator concat(DoubleIterator[] a, int offset, int length) {
        return new IteratorConcatenator(a, offset, length);
    }

    public static DoubleIterator unmodifiable(DoubleIterator i) {
        return new UnmodifiableIterator(i);
    }

    public static DoubleBidirectionalIterator unmodifiable(DoubleBidirectionalIterator i) {
        return new UnmodifiableBidirectionalIterator(i);
    }

    public static DoubleListIterator unmodifiable(DoubleListIterator i) {
        return new UnmodifiableListIterator(i);
    }

    public static class UnmodifiableListIterator
    extends AbstractDoubleListIterator {
        protected final DoubleListIterator i;

        public UnmodifiableListIterator(DoubleListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public double nextDouble() {
            return this.i.nextDouble();
        }

        public double previousDouble() {
            return this.i.previousDouble();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    extends AbstractDoubleBidirectionalIterator {
        protected final DoubleBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(DoubleBidirectionalIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public double nextDouble() {
            return this.i.nextDouble();
        }

        public double previousDouble() {
            return this.i.previousDouble();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableIterator
    extends AbstractDoubleIterator {
        protected final DoubleIterator i;

        public UnmodifiableIterator(DoubleIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public double nextDouble() {
            return this.i.nextDouble();
        }

        public Object next() {
            return this.i.next();
        }
    }

    private static class IteratorConcatenator
    extends AbstractDoubleIterator {
        final DoubleIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(DoubleIterator[] a, int offset, int length) {
            this.a = a;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        public boolean hasNext() {
            return this.length > 0;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            double next = this.a[this.lastOffset].nextDouble();
            this.advance();
            return next;
        }

        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        public int skip(int n) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n && this.length != 0) {
                skipped += this.a[this.offset].skip(n - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class ListIteratorWrapper
    extends AbstractDoubleListIterator {
        final ListIterator i;

        public ListIteratorWrapper(ListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public void set(double k) {
            this.i.set(new Double(k));
        }

        public void add(double k) {
            this.i.add(new Double(k));
        }

        public void remove() {
            this.i.remove();
        }

        public double nextDouble() {
            return (Double)this.i.next();
        }

        public double previousDouble() {
            return (Double)this.i.previous();
        }
    }

    private static class IteratorWrapper
    extends AbstractDoubleIterator {
        final Iterator i;

        public IteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            this.i.remove();
        }

        public double nextDouble() {
            return (Double)this.i.next();
        }
    }

    private static class ArrayIterator
    extends AbstractDoubleListIterator {
        private final double[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(double[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        public boolean hasNext() {
            return this.curr < this.length;
        }

        public boolean hasPrevious() {
            return this.curr > 0;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        public double previousDouble() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        public int skip(int n) {
            if (n <= this.length - this.curr) {
                this.curr += n;
                return n;
            }
            n = this.length - this.curr;
            this.curr = this.length;
            return n;
        }

        public int back(int n) {
            if (n <= this.curr) {
                this.curr -= n;
                return n;
            }
            n = this.curr;
            this.curr = 0;
            return n;
        }

        public int nextIndex() {
            return this.curr;
        }

        public int previousIndex() {
            return this.curr - 1;
        }
    }
}

