/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.Serializable;

public class DoubleArrays {
    private static final long ONEOVERPHI = 106039L;
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private DoubleArrays() {
    }

    public static double[] ensureCapacity(double[] array, int length) {
        if (length > array.length) {
            double[] t = new double[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static double[] ensureCapacity(double[] array, int length, int preserve) {
        if (length > array.length) {
            double[] t = new double[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static double[] grow(double[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            double[] t = new double[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static double[] grow(double[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            try {
                double[] t = new double[newLength];
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            catch (Error T) {
                System.err.println(newLength);
                throw T;
            }
        }
        return array;
    }

    public static double[] trim(double[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        double[] t = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static double[] setLength(double[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return DoubleArrays.trim(array, length);
        }
        return DoubleArrays.ensureCapacity(array, length);
    }

    public static double[] copy(double[] array, int offset, int length) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        double[] a = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static double[] copy(double[] array) {
        return (double[])array.clone();
    }

    public static void fill(double[] array, double value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(double[] array, int from, int to, double value) {
        DoubleArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(double[] a1, double[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(double[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(double[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy,
    Serializable {
        private ArrayHashStrategy() {
        }

        public int hashCode(Object o) {
            if (o == null) {
                return 0;
            }
            if (o == HashCommon.REMOVED) {
                return HashCommon.REMOVED.hashCode();
            }
            double[] a = (double[])o;
            int i = a.length;
            int hashCode = -1;
            while (i-- != 0) {
                hashCode = 31 * hashCode + HashCommon.double2int(a[i]);
            }
            return hashCode;
        }

        public boolean equals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            if (a == HashCommon.REMOVED || b == HashCommon.REMOVED) {
                return a == b;
            }
            return DoubleArrays.equals((double[])a, (double[])b);
        }
    }
}

