/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.Double2BooleanMaps;
import it.unimi.dsi.fastutil.doubles.Double2BooleanSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Double2BooleanSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Double2BooleanSortedMaps() {
    }

    public static Double2BooleanSortedMap singleton(double key, boolean value) {
        return new Singleton(key, value);
    }

    public static Double2BooleanSortedMap singleton(double key, boolean value, DoubleComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Double2BooleanSortedMap singleton(Object key, Object value) {
        return new Singleton((Double)key, (Boolean)value);
    }

    public static Double2BooleanSortedMap singleton(Object key, Object value, DoubleComparator comparator) {
        return new Singleton((Double)key, (Boolean)value, comparator);
    }

    public static Double2BooleanSortedMap synchronize(Double2BooleanSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Double2BooleanSortedMap synchronize(Double2BooleanSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Double2BooleanSortedMap unmodifiable(Double2BooleanSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Double2BooleanMaps.UnmodifiableMap
    implements Double2BooleanSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Double2BooleanSortedMap sortedMap;

        protected UnmodifiableSortedMap(Double2BooleanSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Double2BooleanSortedMap subMap(double from, double to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Double2BooleanSortedMap headMap(double to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Double2BooleanSortedMap tailMap(double from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public double firstDoubleKey() {
            return this.sortedMap.firstDoubleKey();
        }

        public double lastDoubleKey() {
            return this.sortedMap.lastDoubleKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Double2BooleanSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Double2BooleanSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Double2BooleanSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Double2BooleanMaps.SynchronizedMap
    implements Double2BooleanSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Double2BooleanSortedMap sortedMap;

        protected SynchronizedSortedMap(Double2BooleanSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Double2BooleanSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Double2BooleanSortedMap subMap(double from, double to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Double2BooleanSortedMap headMap(double to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Double2BooleanSortedMap tailMap(double from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double firstDoubleKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstDoubleKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double lastDoubleKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastDoubleKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Double2BooleanSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Double2BooleanSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Double2BooleanSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Double2BooleanMaps.Singleton
    implements Double2BooleanSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleComparator comparator;

        protected Singleton(double key, boolean value, DoubleComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(double key, boolean value) {
            this(key, value, null);
        }

        final int compare(double k1, double k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = DoubleSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Double2BooleanSortedMap subMap(double from, double to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Double2BooleanSortedMap headMap(double to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Double2BooleanSortedMap tailMap(double from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public double firstDoubleKey() {
            return this.key;
        }

        public double lastDoubleKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Double)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Double)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Double)ofrom, (Double)oto);
        }

        public Object firstKey() {
            return new Double(this.firstDoubleKey());
        }

        public Object lastKey() {
            return new Double(this.lastDoubleKey());
        }
    }

    public static class EmptySortedMap
    extends Double2BooleanMaps.EmptyMap
    implements Double2BooleanSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Double2BooleanSortedMap subMap(double from, double to) {
            return EMPTY_MAP;
        }

        public Double2BooleanSortedMap headMap(double to) {
            return EMPTY_MAP;
        }

        public Double2BooleanSortedMap tailMap(double from) {
            return EMPTY_MAP;
        }

        public double firstDoubleKey() {
            throw new NoSuchElementException();
        }

        public double lastDoubleKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Double)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Double)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Double)ofrom, (Double)oto);
        }

        public Object firstKey() {
            return new Double(this.firstDoubleKey());
        }

        public Object lastKey() {
            return new Double(this.lastDoubleKey());
        }
    }
}

