/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractDoubleCollection
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    public double[] toArray(double[] a) {
        return this.toDoubleArray(a);
    }

    public double[] toDoubleArray() {
        return this.toDoubleArray(null);
    }

    public double[] toDoubleArray(double[] a) {
        if (a == null || a.length < this.size()) {
            a = new double[this.size()];
        }
        DoubleIterators.unwrap(this.doubleIterator(), a);
        return a;
    }

    public boolean addAll(DoubleCollection c) {
        boolean retVal = false;
        DoubleIterator i = c.doubleIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(DoubleCollection c) {
        DoubleIterator i = c.doubleIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextDouble())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(DoubleCollection c) {
        boolean retVal = false;
        int n = this.size();
        DoubleIterator i = this.doubleIterator();
        while (n-- != 0) {
            if (c.contains(i.nextDouble())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(DoubleCollection c) {
        boolean retVal = false;
        int n = c.size();
        DoubleIterator i = c.doubleIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.doubleIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(double k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(double k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem((Double)ok);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.doubleIterator();
    }

    public boolean add(Object o) {
        return this.add((Double)o);
    }

    public boolean rem(Object o) {
        return this.rem((Double)o);
    }

    public boolean contains(Object o) {
        return this.contains((Double)o);
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        DoubleIterator i = this.doubleIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            double k = i.nextDouble();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

