/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDouble2ObjectMap
implements Double2ObjectMap,
Serializable {
    protected Object defRetValue;

    protected AbstractDouble2ObjectMap() {
    }

    public void setDefRetValue(Object rv) {
        this.defaultReturnValue(rv);
    }

    public Object getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(Object rv) {
        this.defRetValue = rv;
    }

    public Object defaultReturnValue() {
        return this.defRetValue;
    }

    public Object put(double key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(double key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        double k = (Double)ok;
        return this.containsKey(k) ? this.get(k) : null;
    }

    public Object put(Object ok, Object ov) {
        double k = (Double)ok;
        Object v = this.put(k, ov);
        return this.containsKey(k) ? v : null;
    }

    public Object remove(Object ok) {
        double k = (Double)ok;
        Object v = this.remove(k);
        return this.containsKey(k) ? v : null;
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Double)ok);
    }

    public boolean containsValue(Object v) {
        return ((ObjectCollection)this.values()).contains(v);
    }

    public boolean containsKey(double k) {
        return ((DoubleSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Double2ObjectMap) {
            while (n-- != 0) {
                Double2ObjectMap.Entry e = (Double2ObjectMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2ObjectMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2ObjectMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Double2ObjectMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2ObjectMap access$000(1 x0) {
                return x0.AbstractDouble2ObjectMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractObjectCollection(){

            public boolean contains(Object k) {
                return AbstractDouble2ObjectMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2ObjectMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public Object next() {
                        return ((Double2ObjectMap.Entry)this.i.next()).getValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2ObjectMap access$100(3 x0) {
                return x0.AbstractDouble2ObjectMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2ObjectMap.Entry e = (Double2ObjectMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Double2ObjectMap.Entry {
        protected double key;
        protected Object value;

        public BasicEntry(Object key, Object value) {
            this.key = (Double)key;
            this.value = value;
        }

        public BasicEntry(double key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Double)e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return HashCommon.double2int(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

