/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2LongMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDouble2LongMap
implements Double2LongMap,
Serializable {
    protected long defRetValue;

    protected AbstractDouble2LongMap() {
    }

    public void setDefRetValue(long rv) {
        this.defaultReturnValue(rv);
    }

    public long getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(long rv) {
        this.defRetValue = rv;
    }

    public long defaultReturnValue() {
        return this.defRetValue;
    }

    public long put(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public long remove(double key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        double k = (Double)ok;
        return this.containsKey(k) ? new Long(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        double k = (Double)ok;
        long v = this.put(k, (Long)ov);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public Object remove(Object ok) {
        double k = (Double)ok;
        long v = this.remove(k);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Long)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Double)ok);
    }

    public boolean containsValue(long v) {
        return ((LongCollection)this.values()).contains(v);
    }

    public boolean containsKey(double k) {
        return ((DoubleSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Double2LongMap) {
            while (n-- != 0) {
                Double2LongMap.Entry e = (Double2LongMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getLongValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2LongMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2LongMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Double2LongMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2LongMap access$000(1 x0) {
                return x0.AbstractDouble2LongMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractLongCollection(){

            public boolean contains(long k) {
                return AbstractDouble2LongMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2LongMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Double2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2LongMap access$100(3 x0) {
                return x0.AbstractDouble2LongMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2LongMap.Entry e = (Double2LongMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getLongValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Double2LongMap.Entry {
        protected double key;
        protected long value;

        public BasicEntry(Object key, Object value) {
            this.key = (Double)key;
            this.value = (Long)value;
        }

        public BasicEntry(double key, long value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getValue() {
            return new Long(this.value);
        }

        public long getLongValue() {
            return this.value;
        }

        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Long(this.setValue((Long)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Double)e.getKey() && this.value == (Long)e.getValue();
        }

        public int hashCode() {
            return HashCommon.double2int(this.key) ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

