/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDouble2IntMap
implements Double2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractDouble2IntMap() {
    }

    public void setDefRetValue(int rv) {
        this.defaultReturnValue(rv);
    }

    public int getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    public int defaultReturnValue() {
        return this.defRetValue;
    }

    public int put(double key, int value) {
        throw new UnsupportedOperationException();
    }

    public int remove(double key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        double k = (Double)ok;
        return this.containsKey(k) ? new Integer(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        double k = (Double)ok;
        int v = this.put(k, (Integer)ov);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public Object remove(Object ok) {
        double k = (Double)ok;
        int v = this.remove(k);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Double)ok);
    }

    public boolean containsValue(int v) {
        return ((IntCollection)this.values()).contains(v);
    }

    public boolean containsKey(double k) {
        return ((DoubleSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Double2IntMap) {
            while (n-- != 0) {
                Double2IntMap.Entry e = (Double2IntMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2IntMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Double2IntMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2IntMap access$000(1 x0) {
                return x0.AbstractDouble2IntMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractDouble2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2IntMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Double2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2IntMap access$100(3 x0) {
                return x0.AbstractDouble2IntMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2IntMap.Entry e = (Double2IntMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Double2IntMap.Entry {
        protected double key;
        protected int value;

        public BasicEntry(Object key, Object value) {
            this.key = (Double)key;
            this.value = (Integer)value;
        }

        public BasicEntry(double key, int value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Integer(this.setValue((Integer)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Double)e.getKey() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

