/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2CharMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDouble2CharMap
implements Double2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractDouble2CharMap() {
    }

    public void setDefRetValue(char rv) {
        this.defaultReturnValue(rv);
    }

    public char getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    public char defaultReturnValue() {
        return this.defRetValue;
    }

    public char put(double key, char value) {
        throw new UnsupportedOperationException();
    }

    public char remove(double key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        double k = (Double)ok;
        return this.containsKey(k) ? new Character(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        double k = (Double)ok;
        char v = this.put(k, ((Character)ov).charValue());
        return this.containsKey(k) ? new Character(v) : null;
    }

    public Object remove(Object ok) {
        double k = (Double)ok;
        char v = this.remove(k);
        return this.containsKey(k) ? new Character(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Double)ok);
    }

    public boolean containsValue(char v) {
        return ((CharCollection)this.values()).contains(v);
    }

    public boolean containsKey(double k) {
        return ((DoubleSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Double2CharMap) {
            while (n-- != 0) {
                Double2CharMap.Entry e = (Double2CharMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2CharMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Double2CharMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2CharMap access$000(1 x0) {
                return x0.AbstractDouble2CharMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractDouble2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2CharMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Double2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2CharMap access$100(3 x0) {
                return x0.AbstractDouble2CharMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2CharMap.Entry e = (Double2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Double2CharMap.Entry {
        protected double key;
        protected char value;

        public BasicEntry(Object key, Object value) {
            this.key = (Double)key;
            this.value = ((Character)value).charValue();
        }

        public BasicEntry(double key, char value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getValue() {
            return new Character(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Character(this.setValue(((Character)value).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Double)e.getKey() && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

