/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2BooleanMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDouble2BooleanMap
implements Double2BooleanMap,
Serializable {
    protected boolean defRetValue;

    protected AbstractDouble2BooleanMap() {
    }

    public void setDefRetValue(boolean rv) {
        this.defaultReturnValue(rv);
    }

    public boolean getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(boolean rv) {
        this.defRetValue = rv;
    }

    public boolean defaultReturnValue() {
        return this.defRetValue;
    }

    public boolean put(double key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(double key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        double k = (Double)ok;
        return this.containsKey(k) ? Boolean.valueOf(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        double k = (Double)ok;
        boolean v = this.put(k, (Boolean)ov);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public Object remove(Object ok) {
        double k = (Double)ok;
        boolean v = this.remove(k);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Boolean)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Double)ok);
    }

    public boolean containsValue(boolean v) {
        return ((BooleanCollection)this.values()).contains(v);
    }

    public boolean containsKey(double k) {
        return ((DoubleSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Double2BooleanMap) {
            while (n-- != 0) {
                Double2BooleanMap.Entry e = (Double2BooleanMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getBooleanValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2BooleanMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2BooleanMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Double2BooleanMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2BooleanMap access$000(1 x0) {
                return x0.AbstractDouble2BooleanMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractBooleanCollection(){

            public boolean contains(boolean k) {
                return AbstractDouble2BooleanMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2BooleanMap.this.size();
            }

            public BooleanIterator booleanIterator() {
                return new AbstractBooleanIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public boolean nextBoolean() {
                        return ((Double2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractDouble2BooleanMap access$100(3 x0) {
                return x0.AbstractDouble2BooleanMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2BooleanMap.Entry e = (Double2BooleanMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getBooleanValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Double2BooleanMap.Entry {
        protected double key;
        protected boolean value;

        public BasicEntry(Object key, Object value) {
            this.key = (Double)key;
            this.value = (Boolean)value;
        }

        public BasicEntry(double key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean getBooleanValue() {
            return this.value;
        }

        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return this.setValue((Boolean)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Double)e.getKey() && this.value == (Boolean)e.getValue();
        }

        public int hashCode() {
            return HashCommon.double2int(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

