/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.chars.CharBidirectionalIterator;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharIterators;
import it.unimi.dsi.fastutil.chars.CharSets;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class CharSortedSets {
    private CharSortedSets() {
    }

    public static CharSortedSet singleton(char element) {
        return new Singleton(element);
    }

    public static CharSortedSet singleton(char element, CharComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static CharSortedSet singleton(Object element) {
        return new Singleton(((Character)element).charValue());
    }

    public static CharSortedSet singleton(Object element, CharComparator comparator) {
        return new Singleton(((Character)element).charValue(), comparator);
    }

    public static CharSortedSet synchronize(CharSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static CharSortedSet synchronize(CharSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static CharSortedSet unmodifiable(CharSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends CharSets.UnmodifiableSet
    implements CharSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final CharSortedSet sortedSet;

        protected UnmodifiableSortedSet(CharSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public CharSortedSet subSet(char from, char to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public CharSortedSet headSet(char to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public CharSortedSet tailSet(char from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public CharBidirectionalIterator iterator(char from) {
            return CharIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        public char firstChar() {
            return this.sortedSet.firstChar();
        }

        public char lastChar() {
            return this.sortedSet.lastChar();
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }

        public Iterator iterator(Object from) {
            return CharIterators.unmodifiable(this.sortedSet.iterator(((Character)from).charValue()));
        }

        public SortedSet subSet(Object from, Object to) {
            return new UnmodifiableSortedSet((CharSortedSet)this.sortedSet.subSet(from, to));
        }

        public SortedSet headSet(Object to) {
            return new UnmodifiableSortedSet((CharSortedSet)this.sortedSet.headSet(to));
        }

        public SortedSet tailSet(Object from) {
            return new UnmodifiableSortedSet((CharSortedSet)this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends CharSets.SynchronizedSet
    implements CharSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final CharSortedSet sortedSet;

        protected SynchronizedSortedSet(CharSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(CharSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public CharSortedSet subSet(char from, char to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public CharSortedSet headSet(char to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public CharSortedSet tailSet(char from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public CharBidirectionalIterator iterator(char from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char firstChar() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstChar();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char lastChar() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastChar();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        public Iterator iterator(Object from) {
            return this.sortedSet.iterator(((Character)from).charValue());
        }

        public SortedSet subSet(Object from, Object to) {
            return new SynchronizedSortedSet((CharSortedSet)this.sortedSet.subSet(from, to), this.sync);
        }

        public SortedSet headSet(Object to) {
            return new SynchronizedSortedSet((CharSortedSet)this.sortedSet.headSet(to), this.sync);
        }

        public SortedSet tailSet(Object from) {
            return new SynchronizedSortedSet((CharSortedSet)this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends CharSets.Singleton
    implements CharSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final CharComparator comparator;

        private Singleton(char element, CharComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(char element) {
            this(element, (CharComparator)null);
        }

        final int compare(char k1, char k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public CharBidirectionalIterator iterator(char from) {
            CharBidirectionalIterator i = (CharBidirectionalIterator)this.charIterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public CharSortedSet subSet(char from, char to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public CharSortedSet headSet(char to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public CharSortedSet tailSet(char from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public char firstChar() {
            return this.element;
        }

        public char lastChar() {
            return this.element;
        }

        public Object first() {
            return new Character(this.element);
        }

        public Object last() {
            return new Character(this.element);
        }

        public Iterator iterator(Object from) {
            return this.iterator(((Character)from).charValue());
        }

        public SortedSet subSet(Object from, Object to) {
            return this.subSet(((Character)from).charValue(), ((Character)to).charValue());
        }

        public SortedSet headSet(Object to) {
            return this.headSet(((Character)to).charValue());
        }

        public SortedSet tailSet(Object from) {
            return this.tailSet(((Character)from).charValue());
        }
    }
}

