/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharCollections;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharIterators;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CharSets {
    private CharSets() {
    }

    public static CharSet singleton(char element) {
        return new Singleton(element);
    }

    public static CharSet singleton(Object element) {
        return new Singleton(((Character)element).charValue());
    }

    public static CharSet synchronize(CharSet s) {
        return new SynchronizedSet(s);
    }

    public static CharSet synchronize(CharSet s, Object sync) {
        return new SynchronizedSet(s, sync);
    }

    public static CharSet unmodifiable(CharSet s) {
        return new UnmodifiableSet(s);
    }

    public static class UnmodifiableSet
    extends CharCollections.UnmodifiableCollection
    implements CharSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(CharSet s) {
            super(s);
        }

        public boolean remove(char k) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }
    }

    public static class SynchronizedSet
    extends CharCollections.SynchronizedCollection
    implements CharSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(CharSet s, Object sync) {
            super(s, sync);
        }

        protected SynchronizedSet(CharSet s) {
            super(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(char k) {
            Object object = this.sync;
            synchronized (object) {
                return ((CharSet)this.collection).remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }
    }

    public static class Singleton
    extends AbstractCharSet
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final char element;

        protected Singleton(char element) {
            this.element = element;
        }

        public boolean add(char k) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(char k) {
            return k == this.element;
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public char[] toCharArray() {
            char[] a = new char[]{this.element};
            return a;
        }

        public CharIterator charIterator() {
            return CharIterators.wrap(this.toCharArray());
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }
}

