/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Lists;
import it.unimi.dsi.fastutil.chars.AbstractCharList;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharCollections;
import it.unimi.dsi.fastutil.chars.CharIterators;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class CharLists {
    private CharLists() {
    }

    public static CharList singleton(char element) {
        return new Singleton(element);
    }

    public static CharList singleton(Object element) {
        return new Singleton(((Character)element).charValue());
    }

    public static CharList synchronize(CharList l) {
        return new SynchronizedList(l);
    }

    public static CharList synchronize(CharList l, Object sync) {
        return new SynchronizedList(l, sync);
    }

    public static CharList unmodifiable(CharList l) {
        return new UnmodifiableList(l);
    }

    public static class UnmodifiableList
    extends CharCollections.UnmodifiableCollection
    implements CharList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final CharList list;

        protected UnmodifiableList(CharList l) {
            super(l);
            this.list = l;
        }

        public char getChar(int i) {
            return this.list.getChar(i);
        }

        public char set(int i, char k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, char k) {
            throw new UnsupportedOperationException();
        }

        public char removeChar(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(char k) {
            return this.list.indexOf(k);
        }

        public int lastIndexOf(char k) {
            return this.list.lastIndexOf(k);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, CharList l) {
            throw new UnsupportedOperationException();
        }

        public void getElements(int from, char[] a, int offset, int length) {
            this.list.getElements(from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, char[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, char[] a) {
            throw new UnsupportedOperationException();
        }

        public void size(int size) {
            this.list.size(size);
        }

        public ListIterator listIterator() {
            return CharIterators.unmodifiable((CharListIterator)this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return CharIterators.unmodifiable((CharListIterator)this.list.listIterator(i));
        }

        public CharListIterator charListIterator() {
            return CharIterators.unmodifiable(this.list.charListIterator());
        }

        public CharListIterator charListIterator(int i) {
            return CharIterators.unmodifiable(this.list.charListIterator(i));
        }

        public List subList(int from, int to) {
            return new UnmodifiableList((CharList)this.list.subList(from, to));
        }

        public CharList charSubList(int from, int to) {
            return new UnmodifiableList(this.list.charSubList(from, to));
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public int compareTo(Object o) {
            return this.list.compareTo(o);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class SynchronizedList
    extends CharCollections.SynchronizedCollection
    implements CharList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final CharList list;

        protected SynchronizedList(CharList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedList(CharList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char getChar(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getChar(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char set(int i, char k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, char k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char removeChar(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeChar(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(char k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(char k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, CharCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(CharList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, CharList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getElements(int from, char[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, char[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, char[] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.list.listIterator(i);
        }

        public CharListIterator charListIterator() {
            return this.list.charListIterator();
        }

        public CharListIterator charListIterator(int i) {
            return this.list.charListIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList((CharList)this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharList charSubList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.charSubList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int compareTo(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }
    }

    public static class Singleton
    extends AbstractCharList
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        private final char element;

        private Singleton(char element) {
            this.element = element;
        }

        public boolean rem(char k) {
            throw new UnsupportedOperationException();
        }

        public boolean add(char k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, char k) {
            throw new UnsupportedOperationException();
        }

        public char getChar(int i) {
            if (i == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public char removeChar(int i) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(char k) {
            return k == this.element;
        }

        public boolean addAll(CharList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, CharList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public char[] toCharArray() {
            char[] a = new char[]{this.element};
            return a;
        }

        public CharListIterator charListIterator() {
            return CharIterators.wrap(this.toCharArray());
        }

        public CharListIterator charListIterator(int i) {
            if (i > 1 || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            CharListIterator l = CharIterators.wrap(this.toCharArray());
            if (i == 1) {
                l.next();
            }
            return l;
        }

        public CharList charSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return Lists.EMPTY_LIST;
            }
            return this;
        }

        public int size() {
            return 1;
        }

        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }
}

