/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CharArrayFrontCodedList
extends AbstractObjectList
implements Serializable,
Cloneable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected int n;
    protected int ratio;
    protected char[] array;
    protected transient int[] p;
    private static final boolean ASSERTS = true;

    public CharArrayFrontCodedList(Iterator arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        char[] array = CharArrays.EMPTY_ARRAY;
        int[] p = IntArrays.EMPTY_ARRAY;
        char[][] a = new char[2][];
        int curSize = 0;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = (char[])arrays.next();
            int length = a[b].length;
            if (this.n % ratio == 0) {
                p = IntArrays.grow(p, this.n / ratio + 1);
                p[this.n / ratio] = curSize;
                array = CharArrays.grow(array, curSize + CharArrayFrontCodedList.count(length) + length, curSize);
                curSize += CharArrayFrontCodedList.writeInt(array, length, curSize);
                System.arraycopy(a[b], 0, array, curSize, length);
                curSize += length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = CharArrays.grow(array, curSize + CharArrayFrontCodedList.count(length -= common) + CharArrayFrontCodedList.count(common) + length, curSize);
                curSize += CharArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += CharArrayFrontCodedList.writeInt(array, common, curSize);
                System.arraycopy(a[b], common, array, curSize, length);
                curSize += length;
            }
            b = 1 - b;
            ++this.n;
        }
        this.ratio = ratio;
        this.array = CharArrays.trim(array, curSize);
        this.p = IntArrays.trim(p, (this.n + ratio - 1) / ratio);
    }

    public CharArrayFrontCodedList(Collection c, int ratio) {
        this(c.iterator(), ratio);
    }

    private static int readInt(char[] a, int pos) {
        return a[pos] < '\u8000' ? a[pos] : (a[pos] & Short.MAX_VALUE) << 16 | a[pos + 1];
    }

    private static int readCount(char[] a, int pos) {
        return a[pos] < '\u8000' ? 1 : 2;
    }

    private static int count(int length) {
        return length < 32768 ? 1 : 2;
    }

    private static int writeInt(char[] a, int length, int pos) {
        if (length < 32768) {
            a[pos] = (char)length;
            return 1;
        }
        a[pos++] = (char)(length >>> 16 | 0x8000);
        a[pos] = (char)(length & 0xFFFF);
        return 2;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        char[] array = this.array;
        int delta = index % this.ratio;
        int pos = this.p[index / this.ratio];
        int length = CharArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += CharArrayFrontCodedList.count(length) + length;
        length = CharArrayFrontCodedList.readInt(array, pos);
        int common = CharArrayFrontCodedList.readInt(array, pos + CharArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = CharArrayFrontCodedList.readInt(array, pos += CharArrayFrontCodedList.count(length) + CharArrayFrontCodedList.count(common) + length);
            common = CharArrayFrontCodedList.readInt(array, pos + CharArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, char[] a, int offset, int length) {
        int startPos;
        int delta = index % this.ratio;
        int pos = startPos = this.p[index / this.ratio];
        int arrayLength = CharArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + CharArrayFrontCodedList.count(arrayLength);
            System.arraycopy(this.array, pos, a, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            int prevArrayPos = pos + CharArrayFrontCodedList.count(arrayLength) + (i != 0 ? CharArrayFrontCodedList.count(common) : 0);
            common = CharArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + arrayLength) + CharArrayFrontCodedList.count(arrayLength = CharArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            System.arraycopy(this.array, prevArrayPos, a, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            System.arraycopy(this.array, pos + CharArrayFrontCodedList.count(arrayLength) + CharArrayFrontCodedList.count(common), a, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    public Object get(int index) {
        return this.getArray(index);
    }

    public char[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        char[] a = new char[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int get(int index, char[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        CharArrays.ensureOffsetLength(a, offset, length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, char[] a) {
        return this.get(index, a, 0, a.length);
    }

    public int size() {
        return this.n;
    }

    public ObjectListIterator objectListIterator(final int start) {
        this.ensureIndex(start);
        return new AbstractObjectListIterator(){
            char[] a = CharArrays.EMPTY_ARRAY;
            int i = 0;
            int pos = 0;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == CharArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = CharArrayFrontCodedList.this.p[start / CharArrayFrontCodedList.this.ratio];
                        int j = start % CharArrayFrontCodedList.this.ratio;
                        this.i = start - j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            public boolean hasNext() {
                return this.i < CharArrayFrontCodedList.this.n;
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public int previousIndex() {
                return this.i - 1;
            }

            public int nextIndex() {
                return this.i;
            }

            public Object next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % CharArrayFrontCodedList.this.ratio == 0) {
                    this.pos = CharArrayFrontCodedList.this.p[this.i / CharArrayFrontCodedList.this.ratio];
                    length = CharArrayFrontCodedList.readInt(CharArrayFrontCodedList.this.array, this.pos);
                    this.a = CharArrays.ensureCapacity(this.a, length, 0);
                    System.arraycopy(CharArrayFrontCodedList.this.array, this.pos + CharArrayFrontCodedList.count(length), this.a, 0, length);
                    this.pos += length + CharArrayFrontCodedList.count(length);
                    this.inSync = true;
                } else if (this.inSync) {
                    length = CharArrayFrontCodedList.readInt(CharArrayFrontCodedList.this.array, this.pos);
                    int common = CharArrayFrontCodedList.readInt(CharArrayFrontCodedList.this.array, this.pos + CharArrayFrontCodedList.count(length));
                    this.a = CharArrays.ensureCapacity(this.a, length + common, common);
                    System.arraycopy(CharArrayFrontCodedList.this.array, this.pos + CharArrayFrontCodedList.count(length) + CharArrayFrontCodedList.count(common), this.a, common, length);
                    this.pos += CharArrayFrontCodedList.count(length) + CharArrayFrontCodedList.count(common) + length;
                    length += common;
                } else {
                    length = CharArrayFrontCodedList.this.length(this.i);
                    this.a = CharArrays.ensureCapacity(this.a, length, 0);
                    CharArrayFrontCodedList.this.extract(this.i, this.a, 0, length);
                }
                ++this.i;
                return CharArrays.copy(this.a, 0, length);
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return (char[])CharArrayFrontCodedList.this.get(--this.i);
            }
        };
    }

    public Object clone() {
        CharArrayFrontCodedList c;
        try {
            c = (CharArrayFrontCodedList)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.array = (char[])this.array.clone();
        c.p = (int[])this.p.clone();
        return c;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ ");
        for (int i = 0; i < this.n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(CharArrayList.wrap(this.getArray(i)).toString());
        }
        s.append(" ]");
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int[] p = new int[(this.n + this.ratio - 1) / this.ratio];
        char[] a = this.array;
        int i = 0;
        int pos = 0;
        for (i = 0; i < this.n; ++i) {
            int length = CharArrayFrontCodedList.readInt(a, pos);
            if (i % this.ratio == 0) {
                p[i / this.ratio] = pos;
                pos += CharArrayFrontCodedList.count(length) + length;
                continue;
            }
            int common = CharArrayFrontCodedList.readInt(a, pos + CharArrayFrontCodedList.count(length));
            pos += CharArrayFrontCodedList.count(length) + CharArrayFrontCodedList.count(common) + length;
        }
        this.p = p;
    }
}

