/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.chars.AbstractChar2ReferenceSortedMap;
import it.unimi.dsi.fastutil.chars.AbstractCharSortedSet;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import it.unimi.dsi.fastutil.chars.Char2ReferenceSortedMap;
import it.unimi.dsi.fastutil.chars.CharBidirectionalIterator;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Char2ReferenceLinkedOpenHashMap
extends AbstractChar2ReferenceSortedMap
implements Serializable,
Cloneable,
Hash,
Char2ReferenceSortedMap {
    protected transient char[] key;
    protected transient Object[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient CharSet keys;
    protected volatile transient ReferenceCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Char2ReferenceLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new char[this.free];
        this.value = new Object[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Char2ReferenceLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Char2ReferenceLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Char2ReferenceLinkedOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2ReferenceLinkedOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Char2ReferenceLinkedOpenHashMap(Char2ReferenceMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Char2ReferenceLinkedOpenHashMap(Char2ReferenceMap m) {
        this(m, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(char k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        char[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(char k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        char[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public Object put(char k, Object v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            Object oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        Object v = ov;
        char k = ((Character)ok).charValue();
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            Object oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public boolean containsValue(Object v) {
        Object[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.value, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public char firstCharKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public char lastCharKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public Comparator comparator() {
        return null;
    }

    public Char2ReferenceSortedMap tailMap(char from) {
        throw new UnsupportedOperationException();
    }

    public Char2ReferenceSortedMap headMap(char to) {
        throw new UnsupportedOperationException();
    }

    public Char2ReferenceSortedMap subMap(char from, char to) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(char k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(char k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public Object remove(char k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        Object v = this.value[i];
        this.value[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return v;
    }

    public Object get(Object ok) {
        int i = this.findKey(((Character)ok).charValue());
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public Object remove(Object ok) {
        char k = ((Character)ok).charValue();
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        Object v = this.value[i];
        this.value[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return v;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Char2ReferenceLinkedOpenHashMap.this.findKey(((Character)e.getKey()).charValue());
                    return i >= 0 && Char2ReferenceLinkedOpenHashMap.this.value[i] == e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Char2ReferenceLinkedOpenHashMap.this.findKey(((Character)e.getKey()).charValue());
                    if (i >= 0) {
                        Char2ReferenceLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Char2ReferenceLinkedOpenHashMap.this.count;
                }

                public void clear() {
                    Char2ReferenceLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection(){

                public ObjectIterator objectIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Char2ReferenceLinkedOpenHashMap.this.count;
                }

                public boolean contains(Object v) {
                    return Char2ReferenceLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Char2ReferenceLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        char[] key = this.key;
        char[] newKey = new char[newN];
        Object[] value = this.value;
        Object[] newValue = new Object[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            char k = key[i];
            Object v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Char2ReferenceLinkedOpenHashMap c;
        try {
            c = (Char2ReferenceLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (char[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            if (this != this.value[i]) {
                t ^= System.identityHashCode(this.value[i]);
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        char[] key = this.key;
        Object[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeChar(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void checkTable() {
        char k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        CharBidirectionalIterator i = (CharBidirectionalIterator)this.keySet().iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.nextChar();
            if (!this.containsKey(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = ((CharSortedSet)this.keySet()).iterator(this.lastCharKey());
            while (n-- != 0) {
                k = i.previousChar();
                if (!this.containsKey(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new char[n];
        char[] key = this.key;
        this.value = new Object[n];
        Object[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            char k = s.readChar();
            Object v = s.readObject();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectListIterator {
        public Object previous() {
            return Char2ReferenceLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Object next() {
            return Char2ReferenceLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public void set(Object v) {
            throw new UnsupportedOperationException();
        }

        public void add(Object v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractCharSortedSet
    implements CharSortedSet {
        private KeySet() {
        }

        public CharBidirectionalIterator iterator(char from) {
            return new KeyIterator(from);
        }

        public CharIterator charIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Char2ReferenceLinkedOpenHashMap.this.count;
        }

        public boolean contains(char k) {
            return Char2ReferenceLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(char k) {
            int oldCount = Char2ReferenceLinkedOpenHashMap.this.count;
            Char2ReferenceLinkedOpenHashMap.this.remove(k);
            return Char2ReferenceLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Char2ReferenceLinkedOpenHashMap.this.clear();
        }

        public char firstChar() {
            if (Char2ReferenceLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Char2ReferenceLinkedOpenHashMap.this.key[Char2ReferenceLinkedOpenHashMap.this.first];
        }

        public char lastChar() {
            if (Char2ReferenceLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Char2ReferenceLinkedOpenHashMap.this.key[Char2ReferenceLinkedOpenHashMap.this.last];
        }

        public Comparator comparator() {
            return null;
        }

        public final CharSortedSet tailSet(char from) {
            throw new UnsupportedOperationException();
        }

        public final CharSortedSet headSet(char to) {
            throw new UnsupportedOperationException();
        }

        public final CharSortedSet subSet(char from, char to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements CharListIterator {
        public KeyIterator(char k) {
            super(k);
        }

        public char previousChar() {
            return Char2ReferenceLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public Object previous() {
            return new Character(Char2ReferenceLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        public KeyIterator() {
        }

        public char nextChar() {
            return Char2ReferenceLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Object next() {
            return new Character(Char2ReferenceLinkedOpenHashMap.this.key[this.nextEntry()]);
        }

        public void set(char k) {
            throw new UnsupportedOperationException();
        }

        public void add(char k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Char2ReferenceLinkedOpenHashMap.this.first;
        }

        MapIterator(char from) {
            if (Char2ReferenceLinkedOpenHashMap.this.key[Char2ReferenceLinkedOpenHashMap.this.last] == from) {
                this.prev = Char2ReferenceLinkedOpenHashMap.this.last;
                this.index = Char2ReferenceLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Char2ReferenceLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Char2ReferenceLinkedOpenHashMap.this.first;
                while (Char2ReferenceLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = Char2ReferenceLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = Char2ReferenceLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public Object previous() {
            return new MapEntry(this.previousEntry());
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Char2ReferenceLinkedOpenHashMap.this.state[this.curr] = 1;
            Char2ReferenceLinkedOpenHashMap.this.value[this.curr] = HashCommon.REMOVED;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Char2ReferenceLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Char2ReferenceLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Char2ReferenceLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Char2ReferenceLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Char2ReferenceLinkedOpenHashMap.this.link[n] = Char2ReferenceLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Char2ReferenceLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Char2ReferenceLinkedOpenHashMap.this.link[n] = Char2ReferenceLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Char2ReferenceMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return new Character(Char2ReferenceLinkedOpenHashMap.this.key[this.index]);
        }

        public char getCharKey() {
            return Char2ReferenceLinkedOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return Char2ReferenceLinkedOpenHashMap.this.value[this.index];
        }

        public Object setValue(Object v) {
            Object oldValue = Char2ReferenceLinkedOpenHashMap.this.value[this.index];
            Char2ReferenceLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Char2ReferenceLinkedOpenHashMap.this.key[this.index] == ((Character)e.getKey()).charValue() && Char2ReferenceLinkedOpenHashMap.this.value[this.index] == e.getValue();
        }

        public int hashCode() {
            return Char2ReferenceLinkedOpenHashMap.this.key[this.index] ^ System.identityHashCode(Char2ReferenceLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Char2ReferenceLinkedOpenHashMap.this.key[this.index] + "->" + Char2ReferenceLinkedOpenHashMap.this.value[this.index];
        }
    }
}

