/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.Char2CharMaps;
import it.unimi.dsi.fastutil.chars.Char2CharSortedMap;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Char2CharSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Char2CharSortedMaps() {
    }

    public static Char2CharSortedMap singleton(char key, char value) {
        return new Singleton(key, value);
    }

    public static Char2CharSortedMap singleton(char key, char value, CharComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Char2CharSortedMap singleton(Object key, Object value) {
        return new Singleton(((Character)key).charValue(), ((Character)value).charValue());
    }

    public static Char2CharSortedMap singleton(Object key, Object value, CharComparator comparator) {
        return new Singleton(((Character)key).charValue(), ((Character)value).charValue(), comparator);
    }

    public static Char2CharSortedMap synchronize(Char2CharSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Char2CharSortedMap synchronize(Char2CharSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Char2CharSortedMap unmodifiable(Char2CharSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Char2CharMaps.UnmodifiableMap
    implements Char2CharSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Char2CharSortedMap sortedMap;

        protected UnmodifiableSortedMap(Char2CharSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Char2CharSortedMap subMap(char from, char to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Char2CharSortedMap headMap(char to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Char2CharSortedMap tailMap(char from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public char firstCharKey() {
            return this.sortedMap.firstCharKey();
        }

        public char lastCharKey() {
            return this.sortedMap.lastCharKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Char2CharSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Char2CharSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Char2CharSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Char2CharMaps.SynchronizedMap
    implements Char2CharSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Char2CharSortedMap sortedMap;

        protected SynchronizedSortedMap(Char2CharSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Char2CharSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Char2CharSortedMap subMap(char from, char to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Char2CharSortedMap headMap(char to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Char2CharSortedMap tailMap(char from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char firstCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char lastCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Char2CharSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Char2CharSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Char2CharSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Char2CharMaps.Singleton
    implements Char2CharSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final CharComparator comparator;

        protected Singleton(char key, char value, CharComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(char key, char value) {
            this(key, value, null);
        }

        final int compare(char k1, char k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Char2CharSortedMap subMap(char from, char to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Char2CharSortedMap headMap(char to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Char2CharSortedMap tailMap(char from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public char firstCharKey() {
            return this.key;
        }

        public char lastCharKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Character)oto).charValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Character)ofrom).charValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Character)ofrom).charValue(), ((Character)oto).charValue());
        }

        public Object firstKey() {
            return new Character(this.firstCharKey());
        }

        public Object lastKey() {
            return new Character(this.lastCharKey());
        }
    }

    public static class EmptySortedMap
    extends Char2CharMaps.EmptyMap
    implements Char2CharSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Char2CharSortedMap subMap(char from, char to) {
            return EMPTY_MAP;
        }

        public Char2CharSortedMap headMap(char to) {
            return EMPTY_MAP;
        }

        public Char2CharSortedMap tailMap(char from) {
            return EMPTY_MAP;
        }

        public char firstCharKey() {
            throw new NoSuchElementException();
        }

        public char lastCharKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Character)oto).charValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Character)ofrom).charValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Character)ofrom).charValue(), ((Character)oto).charValue());
        }

        public Object firstKey() {
            return new Character(this.firstCharKey());
        }

        public Object lastKey() {
            return new Character(this.lastCharKey());
        }
    }
}

