/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.Char2BooleanMaps;
import it.unimi.dsi.fastutil.chars.Char2BooleanSortedMap;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Char2BooleanSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Char2BooleanSortedMaps() {
    }

    public static Char2BooleanSortedMap singleton(char key, boolean value) {
        return new Singleton(key, value);
    }

    public static Char2BooleanSortedMap singleton(char key, boolean value, CharComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Char2BooleanSortedMap singleton(Object key, Object value) {
        return new Singleton(((Character)key).charValue(), (Boolean)value);
    }

    public static Char2BooleanSortedMap singleton(Object key, Object value, CharComparator comparator) {
        return new Singleton(((Character)key).charValue(), (Boolean)value, comparator);
    }

    public static Char2BooleanSortedMap synchronize(Char2BooleanSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Char2BooleanSortedMap synchronize(Char2BooleanSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Char2BooleanSortedMap unmodifiable(Char2BooleanSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Char2BooleanMaps.UnmodifiableMap
    implements Char2BooleanSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Char2BooleanSortedMap sortedMap;

        protected UnmodifiableSortedMap(Char2BooleanSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Char2BooleanSortedMap subMap(char from, char to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Char2BooleanSortedMap headMap(char to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Char2BooleanSortedMap tailMap(char from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public char firstCharKey() {
            return this.sortedMap.firstCharKey();
        }

        public char lastCharKey() {
            return this.sortedMap.lastCharKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Char2BooleanSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Char2BooleanSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Char2BooleanSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Char2BooleanMaps.SynchronizedMap
    implements Char2BooleanSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Char2BooleanSortedMap sortedMap;

        protected SynchronizedSortedMap(Char2BooleanSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Char2BooleanSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Char2BooleanSortedMap subMap(char from, char to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Char2BooleanSortedMap headMap(char to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Char2BooleanSortedMap tailMap(char from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char firstCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char lastCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Char2BooleanSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Char2BooleanSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Char2BooleanSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Char2BooleanMaps.Singleton
    implements Char2BooleanSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final CharComparator comparator;

        protected Singleton(char key, boolean value, CharComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(char key, boolean value) {
            this(key, value, null);
        }

        final int compare(char k1, char k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Char2BooleanSortedMap subMap(char from, char to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Char2BooleanSortedMap headMap(char to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Char2BooleanSortedMap tailMap(char from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public char firstCharKey() {
            return this.key;
        }

        public char lastCharKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Character)oto).charValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Character)ofrom).charValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Character)ofrom).charValue(), ((Character)oto).charValue());
        }

        public Object firstKey() {
            return new Character(this.firstCharKey());
        }

        public Object lastKey() {
            return new Character(this.lastCharKey());
        }
    }

    public static class EmptySortedMap
    extends Char2BooleanMaps.EmptyMap
    implements Char2BooleanSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Char2BooleanSortedMap subMap(char from, char to) {
            return EMPTY_MAP;
        }

        public Char2BooleanSortedMap headMap(char to) {
            return EMPTY_MAP;
        }

        public Char2BooleanSortedMap tailMap(char from) {
            return EMPTY_MAP;
        }

        public char firstCharKey() {
            throw new NoSuchElementException();
        }

        public char lastCharKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Character)oto).charValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Character)ofrom).charValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Character)ofrom).charValue(), ((Character)oto).charValue());
        }

        public Object firstKey() {
            return new Character(this.firstCharKey());
        }

        public Object lastKey() {
            return new Character(this.lastCharKey());
        }
    }
}

