/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharListIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractCharList
extends AbstractCharCollection
implements CharList,
CharStack {
    private static final boolean ASSERTS = false;

    protected AbstractCharList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public void add(int index, char k) {
        throw new UnsupportedOperationException();
    }

    public boolean add(char k) {
        this.add(this.size(), k);
        return true;
    }

    public boolean rem(char k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeChar(index);
        return true;
    }

    public char removeChar(int i) {
        throw new UnsupportedOperationException();
    }

    public char set(int index, char k) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, CharCollection c) {
        return this.addAll(index, (Collection)c);
    }

    public boolean addAll(int index, CharList l) {
        return this.addAll(index, (CharCollection)l);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(CharCollection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(CharList l) {
        return this.addAll(this.size(), l);
    }

    public ListIterator listIterator() {
        return this.charListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.charListIterator(index);
    }

    public CharIterator charIterator() {
        return this.charListIterator();
    }

    public CharListIterator charListIterator() {
        return this.charListIterator(0);
    }

    public CharListIterator charListIterator(final int index) {
        return new AbstractCharListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractCharList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractCharList.this.getChar(this.last);
            }

            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractCharList.this.getChar(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(char k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractCharList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(char k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractCharList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractCharList.this.removeChar(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public boolean contains(char k) {
        return this.indexOf(k) >= 0;
    }

    public int indexOf(char k) {
        CharListIterator i = this.charListIterator();
        while (i.hasNext()) {
            char e = i.nextChar();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public int lastIndexOf(char k) {
        CharListIterator i = this.charListIterator(this.size());
        while (i.hasPrevious()) {
            char e = i.previousChar();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public void size(int size) {
        int i = this.size();
        if (size > i) {
            while (i++ < size) {
                this.add('\u0000');
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public CharList charSubList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new CharSubList(this, from, to);
    }

    public List subList(int from, int to) {
        return this.charSubList(from, to);
    }

    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        CharListIterator i = this.charListIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextChar();
            i.remove();
        }
    }

    public void addElements(int index, char[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a[offset++]);
        }
    }

    public void addElements(int index, char[] a) {
        this.addElements(index, a, 0, a.length);
    }

    public void getElements(int from, char[] a, int offset, int length) {
        CharListIterator i = this.charListIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextChar();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof CharList) {
            CharList l = (CharList)o;
            CharListIterator i1 = this.charListIterator();
            CharListIterator i2 = l.charListIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                char e2;
                char e1 = i1.nextChar();
                if ((e1 < (e2 = i2.nextChar()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        List l = (List)o;
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    public int hashCode() {
        CharIterator i = this.charIterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            char k = i.nextChar();
            h = 31 * h + k;
        }
        return h;
    }

    public void push(char o) {
        this.add(o);
    }

    public char popChar() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeChar(this.size() - 1);
    }

    public char topChar() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getChar(this.size() - 1);
    }

    public char peekChar(int i) {
        return this.getChar(this.size() - 1 - i);
    }

    public void add(int index, Object ok) {
        this.add(index, ((Character)ok).charValue());
    }

    public Object set(int index, Object ok) {
        return new Character(this.set(index, ((Character)ok).charValue()));
    }

    public Object get(int index) {
        return new Character(this.getChar(index));
    }

    public int indexOf(Object ok) {
        return this.indexOf(((Character)ok).charValue());
    }

    public int lastIndexOf(Object ok) {
        return this.lastIndexOf(((Character)ok).charValue());
    }

    public Object remove(int index) {
        return new Character(this.removeChar(index));
    }

    public void push(Object o) {
        this.push(((Character)o).charValue());
    }

    public Object pop() {
        return new Character(this.popChar());
    }

    public Object top() {
        return new Character(this.topChar());
    }

    public Object peek(int i) {
        return new Character(this.peekChar(i));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        CharIterator i = this.charIterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            char k = i.nextChar();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class CharSubList
    extends AbstractCharList
    implements Serializable {
        protected final CharList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public CharSubList(CharList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(char k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, char k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        public boolean addAll(int index, Collection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, CharCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, CharList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }

        public char getChar(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getChar(this.from + index);
        }

        public char removeChar(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeChar(this.from + index);
        }

        public boolean rem(char k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeChar(this.from + index);
            return true;
        }

        public char set(int index, char k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public int size() {
            return this.to - this.from;
        }

        public void getElements(int from, char[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        public void addElements(int index, char[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        public CharListIterator charListIterator(int index) {
            this.ensureIndex(index);
            return new AbstractCharListIterator(this, index){
                int pos;
                int last;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ CharSubList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.pos = this.val$index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < this.this$0.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public char nextChar() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return this.this$0.l.getChar(this.this$0.from + this.last);
                }

                public char previousChar() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return this.this$0.l.getChar(this.this$0.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(char k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.add(this.pos++, k);
                    this.last = -1;
                }

                public void set(char k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.removeChar(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        public CharList charSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new CharSubList(this, from, to);
        }
    }
}

