/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharIterators;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCharCollection
implements CharCollection {
    protected AbstractCharCollection() {
    }

    public char[] toArray(char[] a) {
        return this.toCharArray(a);
    }

    public char[] toCharArray() {
        return this.toCharArray(null);
    }

    public char[] toCharArray(char[] a) {
        if (a == null || a.length < this.size()) {
            a = new char[this.size()];
        }
        CharIterators.unwrap(this.charIterator(), a);
        return a;
    }

    public boolean addAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i = c.charIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextChar())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(CharCollection c) {
        CharIterator i = c.charIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextChar())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(CharCollection c) {
        boolean retVal = false;
        int n = this.size();
        CharIterator i = this.charIterator();
        while (n-- != 0) {
            if (c.contains(i.nextChar())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(CharCollection c) {
        boolean retVal = false;
        int n = c.size();
        CharIterator i = c.charIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextChar())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.charIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(char k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(char k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem(((Character)ok).charValue());
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.charIterator();
    }

    public boolean add(Object o) {
        return this.add(((Character)o).charValue());
    }

    public boolean rem(Object o) {
        return this.rem(((Character)o).charValue());
    }

    public boolean contains(Object o) {
        return this.contains(((Character)o).charValue());
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        CharIterator i = this.charIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            char k = i.nextChar();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

