/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ShortMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChar2ShortMap
implements Char2ShortMap,
Serializable {
    protected short defRetValue;

    protected AbstractChar2ShortMap() {
    }

    public void setDefRetValue(short rv) {
        this.defaultReturnValue(rv);
    }

    public short getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(short rv) {
        this.defRetValue = rv;
    }

    public short defaultReturnValue() {
        return this.defRetValue;
    }

    public short put(char key, short value) {
        throw new UnsupportedOperationException();
    }

    public short remove(char key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? new Short(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        char k = ((Character)ok).charValue();
        short v = this.put(k, (Short)ov);
        return this.containsKey(k) ? new Short(v) : null;
    }

    public Object remove(Object ok) {
        char k = ((Character)ok).charValue();
        short v = this.remove(k);
        return this.containsKey(k) ? new Short(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Short)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    public boolean containsValue(short v) {
        return ((ShortCollection)this.values()).contains(v);
    }

    public boolean containsKey(char k) {
        return ((CharSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Char2ShortMap) {
            while (n-- != 0) {
                Char2ShortMap.Entry e = (Char2ShortMap.Entry)i.next();
                this.put(e.getCharKey(), e.getShortValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2ShortMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2ShortMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2ShortMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2ShortMap access$000(1 x0) {
                return x0.AbstractChar2ShortMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractShortCollection(){

            public boolean contains(short k) {
                return AbstractChar2ShortMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2ShortMap.this.size();
            }

            public ShortIterator shortIterator() {
                return new AbstractShortIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Char2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2ShortMap access$100(3 x0) {
                return x0.AbstractChar2ShortMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2ShortMap.Entry e = (Char2ShortMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getShortValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2ShortMap.Entry {
        protected char key;
        protected short value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Character)key).charValue();
            this.value = (Short)value;
        }

        public BasicEntry(char key, short value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Character(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Object getValue() {
            return new Short(this.value);
        }

        public short getShortValue() {
            return this.value;
        }

        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Short(this.setValue((Short)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Short)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

