/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChar2IntMap
implements Char2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractChar2IntMap() {
    }

    public void setDefRetValue(int rv) {
        this.defaultReturnValue(rv);
    }

    public int getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    public int defaultReturnValue() {
        return this.defRetValue;
    }

    public int put(char key, int value) {
        throw new UnsupportedOperationException();
    }

    public int remove(char key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? new Integer(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        char k = ((Character)ok).charValue();
        int v = this.put(k, (Integer)ov);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public Object remove(Object ok) {
        char k = ((Character)ok).charValue();
        int v = this.remove(k);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    public boolean containsValue(int v) {
        return ((IntCollection)this.values()).contains(v);
    }

    public boolean containsKey(char k) {
        return ((CharSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Char2IntMap) {
            while (n-- != 0) {
                Char2IntMap.Entry e = (Char2IntMap.Entry)i.next();
                this.put(e.getCharKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2IntMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2IntMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2IntMap access$000(1 x0) {
                return x0.AbstractChar2IntMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractChar2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2IntMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Char2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2IntMap access$100(3 x0) {
                return x0.AbstractChar2IntMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2IntMap.Entry e = (Char2IntMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2IntMap.Entry {
        protected char key;
        protected int value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Character)key).charValue();
            this.value = (Integer)value;
        }

        public BasicEntry(char key, int value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Character(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Integer(this.setValue((Integer)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

