/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2FloatMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChar2FloatMap
implements Char2FloatMap,
Serializable {
    protected float defRetValue;

    protected AbstractChar2FloatMap() {
    }

    public void setDefRetValue(float rv) {
        this.defaultReturnValue(rv);
    }

    public float getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(float rv) {
        this.defRetValue = rv;
    }

    public float defaultReturnValue() {
        return this.defRetValue;
    }

    public float put(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public float remove(char key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? new Float(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        char k = ((Character)ok).charValue();
        float v = this.put(k, ((Float)ov).floatValue());
        return this.containsKey(k) ? new Float(v) : null;
    }

    public Object remove(Object ok) {
        char k = ((Character)ok).charValue();
        float v = this.remove(k);
        return this.containsKey(k) ? new Float(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Float)ov).floatValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    public boolean containsValue(float v) {
        return ((FloatCollection)this.values()).contains(v);
    }

    public boolean containsKey(char k) {
        return ((CharSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Char2FloatMap) {
            while (n-- != 0) {
                Char2FloatMap.Entry e = (Char2FloatMap.Entry)i.next();
                this.put(e.getCharKey(), e.getFloatValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2FloatMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2FloatMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2FloatMap access$000(1 x0) {
                return x0.AbstractChar2FloatMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractChar2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2FloatMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Char2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2FloatMap access$100(3 x0) {
                return x0.AbstractChar2FloatMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2FloatMap.Entry e = (Char2FloatMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2FloatMap.Entry {
        protected char key;
        protected float value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Character)key).charValue();
            this.value = ((Float)value).floatValue();
        }

        public BasicEntry(char key, float value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Character(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Object getValue() {
            return new Float(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Float(this.setValue(((Float)value).floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

