/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2DoubleMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChar2DoubleMap
implements Char2DoubleMap,
Serializable {
    protected double defRetValue;

    protected AbstractChar2DoubleMap() {
    }

    public void setDefRetValue(double rv) {
        this.defaultReturnValue(rv);
    }

    public double getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(double rv) {
        this.defRetValue = rv;
    }

    public double defaultReturnValue() {
        return this.defRetValue;
    }

    public double put(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public double remove(char key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? new Double(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        char k = ((Character)ok).charValue();
        double v = this.put(k, (Double)ov);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public Object remove(Object ok) {
        char k = ((Character)ok).charValue();
        double v = this.remove(k);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Double)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    public boolean containsValue(double v) {
        return ((DoubleCollection)this.values()).contains(v);
    }

    public boolean containsKey(char k) {
        return ((CharSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Char2DoubleMap) {
            while (n-- != 0) {
                Char2DoubleMap.Entry e = (Char2DoubleMap.Entry)i.next();
                this.put(e.getCharKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2DoubleMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2DoubleMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2DoubleMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2DoubleMap access$000(1 x0) {
                return x0.AbstractChar2DoubleMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractDoubleCollection(){

            public boolean contains(double k) {
                return AbstractChar2DoubleMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2DoubleMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Char2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2DoubleMap access$100(3 x0) {
                return x0.AbstractChar2DoubleMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2DoubleMap.Entry e = (Char2DoubleMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2DoubleMap.Entry {
        protected char key;
        protected double value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Character)key).charValue();
            this.value = (Double)value;
        }

        public BasicEntry(char key, double value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Character(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Object getValue() {
            return new Double(this.value);
        }

        public double getDoubleValue() {
            return this.value;
        }

        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Double(this.setValue((Double)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Double)e.getValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

