/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ByteMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChar2ByteMap
implements Char2ByteMap,
Serializable {
    protected byte defRetValue;

    protected AbstractChar2ByteMap() {
    }

    public void setDefRetValue(byte rv) {
        this.defaultReturnValue(rv);
    }

    public byte getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(byte rv) {
        this.defRetValue = rv;
    }

    public byte defaultReturnValue() {
        return this.defRetValue;
    }

    public byte put(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte remove(char key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? new Byte(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        char k = ((Character)ok).charValue();
        byte v = this.put(k, (Byte)ov);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public Object remove(Object ok) {
        char k = ((Character)ok).charValue();
        byte v = this.remove(k);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    public boolean containsValue(byte v) {
        return ((ByteCollection)this.values()).contains(v);
    }

    public boolean containsKey(char k) {
        return ((CharSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Char2ByteMap) {
            while (n-- != 0) {
                Char2ByteMap.Entry e = (Char2ByteMap.Entry)i.next();
                this.put(e.getCharKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2ByteMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2ByteMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2ByteMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2ByteMap access$000(1 x0) {
                return x0.AbstractChar2ByteMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractByteCollection(){

            public boolean contains(byte k) {
                return AbstractChar2ByteMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2ByteMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Char2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractChar2ByteMap access$100(3 x0) {
                return x0.AbstractChar2ByteMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2ByteMap.Entry e = (Char2ByteMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getByteValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2ByteMap.Entry {
        protected char key;
        protected byte value;

        public BasicEntry(Object key, Object value) {
            this.key = ((Character)key).charValue();
            this.value = (Byte)value;
        }

        public BasicEntry(char key, byte value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Character(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Object getValue() {
            return new Byte(this.value);
        }

        public byte getByteValue() {
            return this.value;
        }

        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Byte(this.setValue((Byte)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Byte)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

