/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.bytes.ByteIndirectHeaps;
import it.unimi.dsi.fastutil.ints.IntArrays;

public class ByteHeapIndirectPriorityQueue
extends ByteHeapSemiIndirectPriorityQueue {
    protected int[] inv;

    public ByteHeapIndirectPriorityQueue(byte[] refArray, int capacity, ByteComparator c) {
        super(refArray, capacity, c);
        if (capacity > 0) {
            this.heap = new int[capacity];
        }
        this.refArray = refArray;
        this.c = c;
        this.inv = new int[refArray.length];
        IntArrays.fill(this.inv, -1);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray, ByteComparator c) {
        this(refArray, refArray.length, c);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray, int[] a, int size, ByteComparator c) {
        this(refArray, 0, c);
        this.heap = a;
        this.size = size;
        int i = size;
        while (i-- != 0) {
            if (this.inv[a[i]] != -1) {
                throw new IllegalArgumentException("Index " + a[i] + " appears twice in the heap");
            }
            this.inv[a[i]] = i;
        }
        ByteIndirectHeaps.makeHeap(refArray, a, this.inv, size, c);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray, int[] a, ByteComparator c) {
        this(refArray, a, a.length, c);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public ByteHeapIndirectPriorityQueue(byte[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    protected void ensureHeapElement(int index) {
        this.ensureElement(index);
        if (this.inv[index] < 0) {
            throw new IllegalArgumentException("Index " + index + " does not belong to the queue");
        }
    }

    protected void ensureNotHeapElement(int index) {
        this.ensureElement(index);
        if (this.inv[index] >= 0) {
            throw new IllegalArgumentException("Index " + index + " belongs to the queue");
        }
    }

    public void enqueue(int x) {
        this.ensureNotHeapElement(x);
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size] = x;
        this.inv[this.heap[this.size]] = this.size++;
        ByteIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, this.size - 1, this.c);
    }

    public int dequeue() {
        this.ensureNonEmpty();
        int result = this.heap[0];
        if (--this.size != 0) {
            this.heap[0] = this.heap[this.size];
            this.inv[this.heap[0]] = 0;
        }
        this.inv[result] = -1;
        if (this.size != 0) {
            ByteIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, 0, this.c);
        }
        return result;
    }

    public void changed() {
        this.ensureNonEmpty();
        ByteIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, 0, this.c);
    }

    public void changed(int index) {
        this.ensureHeapElement(index);
        int newPos = ByteIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, this.inv[index], this.c);
        ByteIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, newPos, this.c);
    }

    public void allChanged() {
        ByteIndirectHeaps.makeHeap(this.refArray, this.heap, this.inv, this.size, this.c);
    }

    public void remove(int index) {
        this.ensureHeapElement(index);
        int result = this.inv[index];
        this.inv[index] = -1;
        if (result < --this.size) {
            this.heap[result] = this.heap[this.size];
            this.inv[this.heap[result]] = result;
            int newPos = ByteIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, result, this.c);
            ByteIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, newPos, this.c);
        }
    }

    public void clear() {
        this.size = 0;
        IntArrays.fill(this.inv, -1);
    }
}

