/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteIterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class ByteCollections {
    private ByteCollections() {
    }

    public static ByteCollection synchronize(ByteCollection c) {
        return new SynchronizedCollection(c);
    }

    public static ByteCollection synchronize(ByteCollection c, Object sync) {
        return new SynchronizedCollection(c, sync);
    }

    public static ByteCollection unmodifiable(ByteCollection c) {
        return new UnmodifiableCollection(c);
    }

    public static class UnmodifiableCollection
    implements ByteCollection,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ByteCollection collection;

        protected UnmodifiableCollection(ByteCollection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(byte o) {
            return this.collection.contains(o);
        }

        public byte[] toByteArray() {
            return this.collection.toByteArray();
        }

        public byte[] toByteArray(byte[] a) {
            return this.collection.toByteArray(a);
        }

        public Iterator iterator() {
            return ByteIterators.unmodifiable((ByteIterator)this.collection.iterator());
        }

        public ByteIterator byteIterator() {
            return ByteIterators.unmodifiable(this.collection.byteIterator());
        }

        public boolean add(byte k) {
            throw new UnsupportedOperationException();
        }

        public boolean rem(byte k) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(ByteCollection c) {
            return this.collection.containsAll(c);
        }

        public boolean removeAll(ByteCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(ByteCollection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.collection.toString();
        }

        public boolean add(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object k) {
            return this.collection.contains(k);
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.collection.toArray(a);
        }

        public byte[] toArray(byte[] a) {
            return this.collection.toByteArray(a);
        }
    }

    public static class SynchronizedCollection
    implements ByteCollection,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ByteCollection collection;
        protected final Object sync;

        protected SynchronizedCollection(ByteCollection c, Object sync) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
            this.sync = sync;
        }

        protected SynchronizedCollection(ByteCollection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(byte o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] toByteArray() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toByteArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] toByteArray(byte[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toByteArray(a);
            }
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public ByteIterator byteIterator() {
            return this.collection.byteIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(byte k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.add(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rem(byte k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.rem(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(ByteCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(ByteCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(ByteCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(ByteCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.collection.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.add(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.contains(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] toArray(byte[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toByteArray(a);
            }
        }
    }
}

