/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import it.unimi.dsi.fastutil.bytes.ByteArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteComparators;
import java.util.Comparator;

public class ByteArrayIndirectDoublePriorityQueue
extends ByteArrayIndirectPriorityQueue
implements IndirectDoublePriorityQueue {
    protected ByteComparator secondaryComparator;

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int capacity, ByteComparator c, ByteComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int capacity, ByteComparator c) {
        super(refArray, capacity, c == null ? ByteComparators.OPPOSITE_COMPARATOR : ByteComparators.oppositeComparator(c));
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, ByteComparator c, ByteComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, ByteComparator c) {
        this(refArray, refArray.length, c);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int[] a, int size, ByteComparator c, ByteComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int[] a, ByteComparator c, ByteComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int[] a, int size, ByteComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int[] a, ByteComparator c) {
        this(refArray, a, a.length, c);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public ByteArrayIndirectDoublePriorityQueue(byte[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        byte first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (this.refArray[this.array[i]] >= first) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        byte last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (last >= this.refArray[this.array[i]]) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public Comparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

