/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ByteArrayFrontCodedList
extends AbstractObjectList
implements Serializable,
Cloneable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected int n;
    protected int ratio;
    protected byte[] array;
    protected transient int[] p;
    private static final boolean ASSERTS = true;

    public ByteArrayFrontCodedList(Iterator arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        byte[] array = ByteArrays.EMPTY_ARRAY;
        int[] p = IntArrays.EMPTY_ARRAY;
        byte[][] a = new byte[2][];
        int curSize = 0;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = (byte[])arrays.next();
            int length = a[b].length;
            if (this.n % ratio == 0) {
                p = IntArrays.grow(p, this.n / ratio + 1);
                p[this.n / ratio] = curSize;
                array = ByteArrays.grow(array, curSize + ByteArrayFrontCodedList.count(length) + length, curSize);
                curSize += ByteArrayFrontCodedList.writeInt(array, length, curSize);
                System.arraycopy(a[b], 0, array, curSize, length);
                curSize += length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = ByteArrays.grow(array, curSize + ByteArrayFrontCodedList.count(length -= common) + ByteArrayFrontCodedList.count(common) + length, curSize);
                curSize += ByteArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += ByteArrayFrontCodedList.writeInt(array, common, curSize);
                System.arraycopy(a[b], common, array, curSize, length);
                curSize += length;
            }
            b = 1 - b;
            ++this.n;
        }
        this.ratio = ratio;
        this.array = ByteArrays.trim(array, curSize);
        this.p = IntArrays.trim(p, (this.n + ratio - 1) / ratio);
    }

    public ByteArrayFrontCodedList(Collection c, int ratio) {
        this(c.iterator(), ratio);
    }

    private static int readInt(byte[] a, int pos) {
        if (a[pos] >= 0) {
            return a[pos];
        }
        if (a[pos + 1] >= 0) {
            return -a[pos] - 1 << 7 | a[pos + 1];
        }
        if (a[pos + 2] >= 0) {
            return -a[pos] - 1 << 14 | -a[pos + 1] - 1 << 7 | a[pos + 2];
        }
        if (a[pos + 3] >= 0) {
            return -a[pos] - 1 << 21 | -a[pos + 1] - 1 << 14 | -a[pos + 2] - 1 << 7 | a[pos + 3];
        }
        return -a[pos] - 1 << 28 | -a[pos + 1] - 1 << 21 | -a[pos + 2] - 1 << 14 | -a[pos + 3] - 1 << 7 | a[pos + 4];
    }

    private static int readCount(byte[] a, int pos) {
        if (a[pos++] >= 0) {
            return 1;
        }
        if (a[pos++] >= 0) {
            return 2;
        }
        if (a[pos++] >= 0) {
            return 3;
        }
        if (a[pos++] >= 0) {
            return 4;
        }
        return 5;
    }

    private static int count(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16384) {
            return 2;
        }
        if (length < 0x200000) {
            return 3;
        }
        if (length < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private static int writeInt(byte[] a, int length, int pos) {
        int count = ByteArrayFrontCodedList.count(length);
        a[pos + count - 1] = (byte)(length & 0x7F);
        if (count != 1) {
            int i = count - 1;
            while (i-- != 0) {
                a[pos + i] = (byte)(-((length >>>= 7) & 0x7F) - 1);
            }
        }
        return count;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        byte[] array = this.array;
        int delta = index % this.ratio;
        int pos = this.p[index / this.ratio];
        int length = ByteArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += ByteArrayFrontCodedList.count(length) + length;
        length = ByteArrayFrontCodedList.readInt(array, pos);
        int common = ByteArrayFrontCodedList.readInt(array, pos + ByteArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = ByteArrayFrontCodedList.readInt(array, pos += ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length);
            common = ByteArrayFrontCodedList.readInt(array, pos + ByteArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, byte[] a, int offset, int length) {
        int startPos;
        int delta = index % this.ratio;
        int pos = startPos = this.p[index / this.ratio];
        int arrayLength = ByteArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + ByteArrayFrontCodedList.count(arrayLength);
            System.arraycopy(this.array, pos, a, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            int prevArrayPos = pos + ByteArrayFrontCodedList.count(arrayLength) + (i != 0 ? ByteArrayFrontCodedList.count(common) : 0);
            common = ByteArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + arrayLength) + ByteArrayFrontCodedList.count(arrayLength = ByteArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            System.arraycopy(this.array, prevArrayPos, a, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            System.arraycopy(this.array, pos + ByteArrayFrontCodedList.count(arrayLength) + ByteArrayFrontCodedList.count(common), a, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    public Object get(int index) {
        return this.getArray(index);
    }

    public byte[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        byte[] a = new byte[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int get(int index, byte[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        ByteArrays.ensureOffsetLength(a, offset, length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, byte[] a) {
        return this.get(index, a, 0, a.length);
    }

    public int size() {
        return this.n;
    }

    public ObjectListIterator objectListIterator(final int start) {
        this.ensureIndex(start);
        return new AbstractObjectListIterator(){
            byte[] a = ByteArrays.EMPTY_ARRAY;
            int i = 0;
            int pos = 0;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == ByteArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = ByteArrayFrontCodedList.this.p[start / ByteArrayFrontCodedList.this.ratio];
                        int j = start % ByteArrayFrontCodedList.this.ratio;
                        this.i = start - j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            public boolean hasNext() {
                return this.i < ByteArrayFrontCodedList.this.n;
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public int previousIndex() {
                return this.i - 1;
            }

            public int nextIndex() {
                return this.i;
            }

            public Object next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % ByteArrayFrontCodedList.this.ratio == 0) {
                    this.pos = ByteArrayFrontCodedList.this.p[this.i / ByteArrayFrontCodedList.this.ratio];
                    length = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedList.this.array, this.pos);
                    this.a = ByteArrays.ensureCapacity(this.a, length, 0);
                    System.arraycopy(ByteArrayFrontCodedList.this.array, this.pos + ByteArrayFrontCodedList.count(length), this.a, 0, length);
                    this.pos += length + ByteArrayFrontCodedList.count(length);
                    this.inSync = true;
                } else if (this.inSync) {
                    length = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedList.this.array, this.pos);
                    int common = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedList.this.array, this.pos + ByteArrayFrontCodedList.count(length));
                    this.a = ByteArrays.ensureCapacity(this.a, length + common, common);
                    System.arraycopy(ByteArrayFrontCodedList.this.array, this.pos + ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common), this.a, common, length);
                    this.pos += ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length;
                    length += common;
                } else {
                    length = ByteArrayFrontCodedList.this.length(this.i);
                    this.a = ByteArrays.ensureCapacity(this.a, length, 0);
                    ByteArrayFrontCodedList.this.extract(this.i, this.a, 0, length);
                }
                ++this.i;
                return ByteArrays.copy(this.a, 0, length);
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return (byte[])ByteArrayFrontCodedList.this.get(--this.i);
            }
        };
    }

    public Object clone() {
        ByteArrayFrontCodedList c;
        try {
            c = (ByteArrayFrontCodedList)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.array = (byte[])this.array.clone();
        c.p = (int[])this.p.clone();
        return c;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ ");
        for (int i = 0; i < this.n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ByteArrayList.wrap(this.getArray(i)).toString());
        }
        s.append(" ]");
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int[] p = new int[(this.n + this.ratio - 1) / this.ratio];
        byte[] a = this.array;
        int i = 0;
        int pos = 0;
        for (i = 0; i < this.n; ++i) {
            int length = ByteArrayFrontCodedList.readInt(a, pos);
            if (i % this.ratio == 0) {
                p[i / this.ratio] = pos;
                pos += ByteArrayFrontCodedList.count(length) + length;
                continue;
            }
            int common = ByteArrayFrontCodedList.readInt(a, pos + ByteArrayFrontCodedList.count(length));
            pos += ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length;
        }
        this.p = p;
    }
}

