/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.Byte2FloatMaps;
import it.unimi.dsi.fastutil.bytes.Byte2FloatSortedMap;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Byte2FloatSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Byte2FloatSortedMaps() {
    }

    public static Byte2FloatSortedMap singleton(byte key, float value) {
        return new Singleton(key, value);
    }

    public static Byte2FloatSortedMap singleton(byte key, float value, ByteComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Byte2FloatSortedMap singleton(Object key, Object value) {
        return new Singleton((Byte)key, ((Float)value).floatValue());
    }

    public static Byte2FloatSortedMap singleton(Object key, Object value, ByteComparator comparator) {
        return new Singleton((Byte)key, ((Float)value).floatValue(), comparator);
    }

    public static Byte2FloatSortedMap synchronize(Byte2FloatSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Byte2FloatSortedMap synchronize(Byte2FloatSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Byte2FloatSortedMap unmodifiable(Byte2FloatSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Byte2FloatMaps.UnmodifiableMap
    implements Byte2FloatSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Byte2FloatSortedMap sortedMap;

        protected UnmodifiableSortedMap(Byte2FloatSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Byte2FloatSortedMap subMap(byte from, byte to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Byte2FloatSortedMap headMap(byte to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Byte2FloatSortedMap tailMap(byte from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public byte firstByteKey() {
            return this.sortedMap.firstByteKey();
        }

        public byte lastByteKey() {
            return this.sortedMap.lastByteKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Byte2FloatSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Byte2FloatSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Byte2FloatSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Byte2FloatMaps.SynchronizedMap
    implements Byte2FloatSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Byte2FloatSortedMap sortedMap;

        protected SynchronizedSortedMap(Byte2FloatSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Byte2FloatSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Byte2FloatSortedMap subMap(byte from, byte to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Byte2FloatSortedMap headMap(byte to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Byte2FloatSortedMap tailMap(byte from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte firstByteKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstByteKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte lastByteKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastByteKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Byte2FloatSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Byte2FloatSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Byte2FloatSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Byte2FloatMaps.Singleton
    implements Byte2FloatSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ByteComparator comparator;

        protected Singleton(byte key, float value, ByteComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(byte key, float value) {
            this(key, value, null);
        }

        final int compare(byte k1, byte k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ByteSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Byte2FloatSortedMap subMap(byte from, byte to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Byte2FloatSortedMap headMap(byte to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Byte2FloatSortedMap tailMap(byte from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public byte firstByteKey() {
            return this.key;
        }

        public byte lastByteKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Byte)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Byte)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Byte)ofrom, (Byte)oto);
        }

        public Object firstKey() {
            return new Byte(this.firstByteKey());
        }

        public Object lastKey() {
            return new Byte(this.lastByteKey());
        }
    }

    public static class EmptySortedMap
    extends Byte2FloatMaps.EmptyMap
    implements Byte2FloatSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Byte2FloatSortedMap subMap(byte from, byte to) {
            return EMPTY_MAP;
        }

        public Byte2FloatSortedMap headMap(byte to) {
            return EMPTY_MAP;
        }

        public Byte2FloatSortedMap tailMap(byte from) {
            return EMPTY_MAP;
        }

        public byte firstByteKey() {
            throw new NoSuchElementException();
        }

        public byte lastByteKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Byte)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Byte)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Byte)ofrom, (Byte)oto);
        }

        public Object firstKey() {
            return new Byte(this.firstByteKey());
        }

        public Object lastKey() {
            return new Byte(this.lastByteKey());
        }
    }
}

