/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2ShortMap;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractByte2ShortMap
implements Byte2ShortMap,
Serializable {
    protected short defRetValue;

    protected AbstractByte2ShortMap() {
    }

    public void setDefRetValue(short rv) {
        this.defaultReturnValue(rv);
    }

    public short getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(short rv) {
        this.defRetValue = rv;
    }

    public short defaultReturnValue() {
        return this.defRetValue;
    }

    public short put(byte key, short value) {
        throw new UnsupportedOperationException();
    }

    public short remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        byte k = (Byte)ok;
        return this.containsKey(k) ? new Short(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        byte k = (Byte)ok;
        short v = this.put(k, (Short)ov);
        return this.containsKey(k) ? new Short(v) : null;
    }

    public Object remove(Object ok) {
        byte k = (Byte)ok;
        short v = this.remove(k);
        return this.containsKey(k) ? new Short(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Short)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Byte)ok);
    }

    public boolean containsValue(short v) {
        return ((ShortCollection)this.values()).contains(v);
    }

    public boolean containsKey(byte k) {
        return ((ByteSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Byte2ShortMap) {
            while (n-- != 0) {
                Byte2ShortMap.Entry e = (Byte2ShortMap.Entry)i.next();
                this.put(e.getByteKey(), e.getShortValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractByteSet(){

            public boolean contains(byte k) {
                return AbstractByte2ShortMap.this.containsKey(k);
            }

            public int size() {
                return AbstractByte2ShortMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Byte2ShortMap.Entry)this.i.next()).getByteKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractByte2ShortMap access$000(1 x0) {
                return x0.AbstractByte2ShortMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractShortCollection(){

            public boolean contains(short k) {
                return AbstractByte2ShortMap.this.containsValue(k);
            }

            public int size() {
                return AbstractByte2ShortMap.this.size();
            }

            public ShortIterator shortIterator() {
                return new AbstractShortIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Byte2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractByte2ShortMap access$100(3 x0) {
                return x0.AbstractByte2ShortMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Byte2ShortMap.Entry e = (Byte2ShortMap.Entry)i.next();
            s.append(String.valueOf(e.getByteKey()));
            s.append("=>");
            s.append(String.valueOf(e.getShortValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Byte2ShortMap.Entry {
        protected byte key;
        protected short value;

        public BasicEntry(Object key, Object value) {
            this.key = (Byte)key;
            this.value = (Short)value;
        }

        public BasicEntry(byte key, short value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Byte(this.key);
        }

        public byte getByteKey() {
            return this.key;
        }

        public Object getValue() {
            return new Short(this.value);
        }

        public short getShortValue() {
            return this.value;
        }

        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Short(this.setValue((Short)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Byte)e.getKey() && this.value == (Short)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

