/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2IntMap;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractByte2IntMap
implements Byte2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractByte2IntMap() {
    }

    public void setDefRetValue(int rv) {
        this.defaultReturnValue(rv);
    }

    public int getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    public int defaultReturnValue() {
        return this.defRetValue;
    }

    public int put(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public int remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        byte k = (Byte)ok;
        return this.containsKey(k) ? new Integer(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        byte k = (Byte)ok;
        int v = this.put(k, (Integer)ov);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public Object remove(Object ok) {
        byte k = (Byte)ok;
        int v = this.remove(k);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Byte)ok);
    }

    public boolean containsValue(int v) {
        return ((IntCollection)this.values()).contains(v);
    }

    public boolean containsKey(byte k) {
        return ((ByteSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Byte2IntMap) {
            while (n-- != 0) {
                Byte2IntMap.Entry e = (Byte2IntMap.Entry)i.next();
                this.put(e.getByteKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractByteSet(){

            public boolean contains(byte k) {
                return AbstractByte2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractByte2IntMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Byte2IntMap.Entry)this.i.next()).getByteKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractByte2IntMap access$000(1 x0) {
                return x0.AbstractByte2IntMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractByte2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractByte2IntMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Byte2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractByte2IntMap access$100(3 x0) {
                return x0.AbstractByte2IntMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Byte2IntMap.Entry e = (Byte2IntMap.Entry)i.next();
            s.append(String.valueOf(e.getByteKey()));
            s.append("=>");
            s.append(String.valueOf(e.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Byte2IntMap.Entry {
        protected byte key;
        protected int value;

        public BasicEntry(Object key, Object value) {
            this.key = (Byte)key;
            this.value = (Integer)value;
        }

        public BasicEntry(byte key, int value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Byte(this.key);
        }

        public byte getByteKey() {
            return this.key;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Integer(this.setValue((Integer)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Byte)e.getKey() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

