/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.Lists;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollections;
import it.unimi.dsi.fastutil.booleans.BooleanIterators;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class BooleanLists {
    private BooleanLists() {
    }

    public static BooleanList singleton(boolean element) {
        return new Singleton(element);
    }

    public static BooleanList singleton(Object element) {
        return new Singleton((Boolean)element);
    }

    public static BooleanList synchronize(BooleanList l) {
        return new SynchronizedList(l);
    }

    public static BooleanList synchronize(BooleanList l, Object sync) {
        return new SynchronizedList(l, sync);
    }

    public static BooleanList unmodifiable(BooleanList l) {
        return new UnmodifiableList(l);
    }

    public static class UnmodifiableList
    extends BooleanCollections.UnmodifiableCollection
    implements BooleanList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final BooleanList list;

        protected UnmodifiableList(BooleanList l) {
            super(l);
            this.list = l;
        }

        public boolean getBoolean(int i) {
            return this.list.getBoolean(i);
        }

        public boolean set(int i, boolean k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, boolean k) {
            throw new UnsupportedOperationException();
        }

        public boolean removeBoolean(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(boolean k) {
            return this.list.indexOf(k);
        }

        public int lastIndexOf(boolean k) {
            return this.list.lastIndexOf(k);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, BooleanCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(BooleanList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, BooleanList l) {
            throw new UnsupportedOperationException();
        }

        public void getElements(int from, boolean[] a, int offset, int length) {
            this.list.getElements(from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, boolean[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, boolean[] a) {
            throw new UnsupportedOperationException();
        }

        public void size(int size) {
            this.list.size(size);
        }

        public ListIterator listIterator() {
            return BooleanIterators.unmodifiable((BooleanListIterator)this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return BooleanIterators.unmodifiable((BooleanListIterator)this.list.listIterator(i));
        }

        public BooleanListIterator booleanListIterator() {
            return BooleanIterators.unmodifiable(this.list.booleanListIterator());
        }

        public BooleanListIterator booleanListIterator(int i) {
            return BooleanIterators.unmodifiable(this.list.booleanListIterator(i));
        }

        public List subList(int from, int to) {
            return new UnmodifiableList((BooleanList)this.list.subList(from, to));
        }

        public BooleanList booleanSubList(int from, int to) {
            return new UnmodifiableList(this.list.booleanSubList(from, to));
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public int compareTo(Object o) {
            return this.list.compareTo(o);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class SynchronizedList
    extends BooleanCollections.SynchronizedCollection
    implements BooleanList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final BooleanList list;

        protected SynchronizedList(BooleanList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedList(BooleanList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getBoolean(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getBoolean(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(int i, boolean k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, boolean k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeBoolean(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeBoolean(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(boolean k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(boolean k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, BooleanCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(BooleanList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, BooleanList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getElements(int from, boolean[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, boolean[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, boolean[] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.list.listIterator(i);
        }

        public BooleanListIterator booleanListIterator() {
            return this.list.booleanListIterator();
        }

        public BooleanListIterator booleanListIterator(int i) {
            return this.list.booleanListIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList((BooleanList)this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BooleanList booleanSubList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.booleanSubList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int compareTo(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }
    }

    public static class Singleton
    extends AbstractBooleanList
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        private final boolean element;

        private Singleton(boolean element) {
            this.element = element;
        }

        public boolean rem(boolean k) {
            throw new UnsupportedOperationException();
        }

        public boolean add(boolean k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, boolean k) {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean(int i) {
            if (i == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean removeBoolean(int i) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(boolean k) {
            return k == this.element;
        }

        public boolean addAll(BooleanList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(BooleanCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, BooleanList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, BooleanCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(BooleanCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(BooleanCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean[] toBooleanArray() {
            boolean[] a = new boolean[]{this.element};
            return a;
        }

        public BooleanListIterator booleanListIterator() {
            return BooleanIterators.wrap(this.toBooleanArray());
        }

        public BooleanListIterator booleanListIterator(int i) {
            if (i > 1 || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            BooleanListIterator l = BooleanIterators.wrap(this.toBooleanArray());
            if (i == 1) {
                l.next();
            }
            return l;
        }

        public BooleanList booleanSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return Lists.EMPTY_LIST;
            }
            return this;
        }

        public int size() {
            return 1;
        }

        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }
}

