/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanBidirectionalIterator;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBidirectionalIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class BooleanIterators {
    private BooleanIterators() {
    }

    public static BooleanListIterator emptyBooleanIterator() {
        return Iterators.EMPTY_ITERATOR;
    }

    public static BooleanListIterator wrap(boolean[] array, int offset, int length) {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static BooleanListIterator wrap(boolean[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(BooleanIterator i, boolean[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.nextBoolean();
        }
        return max - j - 1;
    }

    public static int unwrap(BooleanIterator i, boolean[] array) {
        return BooleanIterators.unwrap(i, array, 0, array.length);
    }

    public static boolean[] unwrap(BooleanIterator i, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        boolean[] array = new boolean[16];
        int j = 0;
        while (max-- != 0 && i.hasNext()) {
            if (j == array.length) {
                array = BooleanArrays.grow(array, j + 1);
            }
            array[j++] = i.nextBoolean();
        }
        return BooleanArrays.trim(array, j);
    }

    public static boolean[] unwrap(BooleanIterator i) {
        return BooleanIterators.unwrap(i, Integer.MAX_VALUE);
    }

    public static int unwrap(BooleanIterator i, BooleanCollection c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            c.add(i.nextBoolean());
        }
        return max - j - 1;
    }

    public static long unwrap(BooleanIterator i, BooleanCollection c) {
        long n = 0L;
        while (i.hasNext()) {
            c.add(i.nextBoolean());
            ++n;
        }
        return n;
    }

    public static int pour(BooleanIterator i, BooleanCollection s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            s.add(i.nextBoolean());
        }
        return max - j - 1;
    }

    public static int pour(BooleanIterator i, BooleanCollection s) {
        return BooleanIterators.pour(i, s, Integer.MAX_VALUE);
    }

    public static BooleanList pour(BooleanIterator i, int max) {
        BooleanArrayList l = new BooleanArrayList();
        BooleanIterators.pour(i, l, max);
        l.trim();
        return l;
    }

    public static BooleanList pour(BooleanIterator i) {
        return BooleanIterators.pour(i, Integer.MAX_VALUE);
    }

    public static BooleanListIterator asBooleanIterator(ListIterator i) {
        if (i instanceof BooleanListIterator) {
            return (BooleanListIterator)i;
        }
        return new ListIteratorWrapper(i);
    }

    public static BooleanIterator asBooleanIterator(Iterator i) {
        if (i instanceof BooleanIterator) {
            return (BooleanIterator)i;
        }
        return new IteratorWrapper(i);
    }

    public static BooleanIterator concat(BooleanIterator[] a) {
        return BooleanIterators.concat(a, 0, a.length);
    }

    public static BooleanIterator concat(BooleanIterator[] a, int offset, int length) {
        return new IteratorConcatenator(a, offset, length);
    }

    public static BooleanIterator unmodifiable(BooleanIterator i) {
        return new UnmodifiableIterator(i);
    }

    public static BooleanBidirectionalIterator unmodifiable(BooleanBidirectionalIterator i) {
        return new UnmodifiableBidirectionalIterator(i);
    }

    public static BooleanListIterator unmodifiable(BooleanListIterator i) {
        return new UnmodifiableListIterator(i);
    }

    public static class UnmodifiableListIterator
    extends AbstractBooleanListIterator {
        protected final BooleanListIterator i;

        public UnmodifiableListIterator(BooleanListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public boolean nextBoolean() {
            return this.i.nextBoolean();
        }

        public boolean previousBoolean() {
            return this.i.previousBoolean();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    extends AbstractBooleanBidirectionalIterator {
        protected final BooleanBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(BooleanBidirectionalIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public boolean nextBoolean() {
            return this.i.nextBoolean();
        }

        public boolean previousBoolean() {
            return this.i.previousBoolean();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableIterator
    extends AbstractBooleanIterator {
        protected final BooleanIterator i;

        public UnmodifiableIterator(BooleanIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean nextBoolean() {
            return this.i.nextBoolean();
        }

        public Object next() {
            return this.i.next();
        }
    }

    private static class IteratorConcatenator
    extends AbstractBooleanIterator {
        final BooleanIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(BooleanIterator[] a, int offset, int length) {
            this.a = a;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        public boolean hasNext() {
            return this.length > 0;
        }

        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            boolean next = this.a[this.lastOffset].nextBoolean();
            this.advance();
            return next;
        }

        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        public int skip(int n) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n && this.length != 0) {
                skipped += this.a[this.offset].skip(n - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class ListIteratorWrapper
    extends AbstractBooleanListIterator {
        final ListIterator i;

        public ListIteratorWrapper(ListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public void set(boolean k) {
            this.i.set(k);
        }

        public void add(boolean k) {
            this.i.add(k);
        }

        public void remove() {
            this.i.remove();
        }

        public boolean nextBoolean() {
            return (Boolean)this.i.next();
        }

        public boolean previousBoolean() {
            return (Boolean)this.i.previous();
        }
    }

    private static class IteratorWrapper
    extends AbstractBooleanIterator {
        final Iterator i;

        public IteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            this.i.remove();
        }

        public boolean nextBoolean() {
            return (Boolean)this.i.next();
        }
    }

    private static class ArrayIterator
    extends AbstractBooleanListIterator {
        private final boolean[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(boolean[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        public boolean hasNext() {
            return this.curr < this.length;
        }

        public boolean hasPrevious() {
            return this.curr > 0;
        }

        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        public boolean previousBoolean() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        public int skip(int n) {
            if (n <= this.length - this.curr) {
                this.curr += n;
                return n;
            }
            n = this.length - this.curr;
            this.curr = this.length;
            return n;
        }

        public int back(int n) {
            if (n <= this.curr) {
                this.curr -= n;
                return n;
            }
            n = this.curr;
            this.curr = 0;
            return n;
        }

        public int nextIndex() {
            return this.curr;
        }

        public int previousIndex() {
            return this.curr - 1;
        }
    }
}

