/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractBooleanList
extends AbstractBooleanCollection
implements BooleanList,
BooleanStack {
    private static final boolean ASSERTS = false;

    protected AbstractBooleanList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public void add(int index, boolean k) {
        throw new UnsupportedOperationException();
    }

    public boolean add(boolean k) {
        this.add(this.size(), k);
        return true;
    }

    public boolean rem(boolean k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeBoolean(index);
        return true;
    }

    public boolean removeBoolean(int i) {
        throw new UnsupportedOperationException();
    }

    public boolean set(int index, boolean k) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, BooleanCollection c) {
        return this.addAll(index, (Collection)c);
    }

    public boolean addAll(int index, BooleanList l) {
        return this.addAll(index, (BooleanCollection)l);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(BooleanCollection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(BooleanList l) {
        return this.addAll(this.size(), l);
    }

    public ListIterator listIterator() {
        return this.booleanListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.booleanListIterator(index);
    }

    public BooleanIterator booleanIterator() {
        return this.booleanListIterator();
    }

    public BooleanListIterator booleanListIterator() {
        return this.booleanListIterator(0);
    }

    public BooleanListIterator booleanListIterator(final int index) {
        return new AbstractBooleanListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractBooleanList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractBooleanList.this.getBoolean(this.last);
            }

            public boolean previousBoolean() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractBooleanList.this.getBoolean(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(boolean k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractBooleanList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(boolean k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractBooleanList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractBooleanList.this.removeBoolean(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public boolean contains(boolean k) {
        return this.indexOf(k) >= 0;
    }

    public int indexOf(boolean k) {
        BooleanListIterator i = this.booleanListIterator();
        while (i.hasNext()) {
            boolean e = i.nextBoolean();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public int lastIndexOf(boolean k) {
        BooleanListIterator i = this.booleanListIterator(this.size());
        while (i.hasPrevious()) {
            boolean e = i.previousBoolean();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public void size(int size) {
        int i = this.size();
        if (size > i) {
            while (i++ < size) {
                this.add(false);
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public BooleanList booleanSubList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new BooleanSubList(this, from, to);
    }

    public List subList(int from, int to) {
        return this.booleanSubList(from, to);
    }

    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        BooleanListIterator i = this.booleanListIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextBoolean();
            i.remove();
        }
    }

    public void addElements(int index, boolean[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a[offset++]);
        }
    }

    public void addElements(int index, boolean[] a) {
        this.addElements(index, a, 0, a.length);
    }

    public void getElements(int from, boolean[] a, int offset, int length) {
        BooleanListIterator i = this.booleanListIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextBoolean();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof BooleanList) {
            BooleanList l = (BooleanList)o;
            BooleanListIterator i1 = this.booleanListIterator();
            BooleanListIterator i2 = l.booleanListIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                boolean e1 = i1.nextBoolean();
                boolean e2 = i2.nextBoolean();
                if ((!e1 && e2 ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        List l = (List)o;
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    public int hashCode() {
        BooleanIterator i = this.booleanIterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            boolean k = i.nextBoolean();
            h = 31 * h + (k ? 1231 : 1237);
        }
        return h;
    }

    public void push(boolean o) {
        this.add(o);
    }

    public boolean popBoolean() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeBoolean(this.size() - 1);
    }

    public boolean topBoolean() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getBoolean(this.size() - 1);
    }

    public boolean peekBoolean(int i) {
        return this.getBoolean(this.size() - 1 - i);
    }

    public void add(int index, Object ok) {
        this.add(index, (Boolean)ok);
    }

    public Object set(int index, Object ok) {
        return this.set(index, (Boolean)ok);
    }

    public Object get(int index) {
        return this.getBoolean(index);
    }

    public int indexOf(Object ok) {
        return this.indexOf((Boolean)ok);
    }

    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Boolean)ok);
    }

    public Object remove(int index) {
        return this.removeBoolean(index);
    }

    public void push(Object o) {
        this.push((Boolean)o);
    }

    public Object pop() {
        return this.popBoolean();
    }

    public Object top() {
        return this.topBoolean();
    }

    public Object peek(int i) {
        return this.peekBoolean(i);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        BooleanIterator i = this.booleanIterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            boolean k = i.nextBoolean();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class BooleanSubList
    extends AbstractBooleanList
    implements Serializable {
        protected final BooleanList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public BooleanSubList(BooleanList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(boolean k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, boolean k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        public boolean addAll(int index, Collection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, BooleanCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, BooleanList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }

        public boolean getBoolean(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getBoolean(this.from + index);
        }

        public boolean removeBoolean(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeBoolean(this.from + index);
        }

        public boolean rem(boolean k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeBoolean(this.from + index);
            return true;
        }

        public boolean set(int index, boolean k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public int size() {
            return this.to - this.from;
        }

        public void getElements(int from, boolean[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        public void addElements(int index, boolean[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        public BooleanListIterator booleanListIterator(int index) {
            this.ensureIndex(index);
            return new AbstractBooleanListIterator(this, index){
                int pos;
                int last;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ BooleanSubList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.pos = this.val$index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < this.this$0.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public boolean nextBoolean() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return this.this$0.l.getBoolean(this.this$0.from + this.last);
                }

                public boolean previousBoolean() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return this.this$0.l.getBoolean(this.this$0.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(boolean k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.add(this.pos++, k);
                    this.last = -1;
                }

                public void set(boolean k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.removeBoolean(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        public BooleanList booleanSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new BooleanSubList(this, from, to);
        }
    }
}

