/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanIterators;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractBooleanCollection
implements BooleanCollection {
    protected AbstractBooleanCollection() {
    }

    public boolean[] toArray(boolean[] a) {
        return this.toBooleanArray(a);
    }

    public boolean[] toBooleanArray() {
        return this.toBooleanArray(null);
    }

    public boolean[] toBooleanArray(boolean[] a) {
        if (a == null || a.length < this.size()) {
            a = new boolean[this.size()];
        }
        BooleanIterators.unwrap(this.booleanIterator(), a);
        return a;
    }

    public boolean addAll(BooleanCollection c) {
        boolean retVal = false;
        BooleanIterator i = c.booleanIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextBoolean())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(BooleanCollection c) {
        BooleanIterator i = c.booleanIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextBoolean())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(BooleanCollection c) {
        boolean retVal = false;
        int n = this.size();
        BooleanIterator i = this.booleanIterator();
        while (n-- != 0) {
            if (c.contains(i.nextBoolean())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(BooleanCollection c) {
        boolean retVal = false;
        int n = c.size();
        BooleanIterator i = c.booleanIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextBoolean())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.booleanIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(boolean k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(boolean k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem((Boolean)ok);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.booleanIterator();
    }

    public boolean add(Object o) {
        return this.add((Boolean)o);
    }

    public boolean rem(Object o) {
        return this.rem((Boolean)o);
    }

    public boolean contains(Object o) {
        return this.contains((Boolean)o);
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        BooleanIterator i = this.booleanIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            boolean k = i.nextBoolean();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

