/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleHeapSemiIndirectPriorityQueue;

public class ScoredDocumentBoundedSizeQueue {
    private final DoubleHeapSemiIndirectPriorityQueue queue;
    private int maxSize;
    public final double[] score;
    public final int[] document;

    public void enqueue(int d, double s) {
        int currentSize = this.queue.size();
        if (currentSize >= this.maxSize) {
            int smallestScoreIndex = this.queue.first();
            if ((double)d > this.score[smallestScoreIndex]) {
                this.document[smallestScoreIndex] = d;
                this.score[smallestScoreIndex] = s;
                this.queue.changed();
            }
        } else {
            this.document[currentSize] = d;
            this.score[currentSize] = s;
            this.queue.enqueue(currentSize);
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public int dequeue() {
        return this.queue.dequeue();
    }

    public ScoredDocumentBoundedSizeQueue(int capacity) {
        this.score = new double[capacity];
        this.maxSize = capacity;
        this.document = new int[this.maxSize];
        this.queue = new DoubleHeapSemiIndirectPriorityQueue(this.score, capacity);
    }

    public ScoredDocumentBoundedSizeQueue(int capacity, DoubleComparator c) {
        this.score = new double[capacity];
        this.maxSize = capacity;
        this.document = new int[this.maxSize];
        this.queue = new DoubleHeapSemiIndirectPriorityQueue(this.score, capacity, c);
    }
}

