/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.FrontCodedStringList;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;

public class PermutedFrontCodedStringList
extends AbstractObjectList
implements Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected final FrontCodedStringList frontCodedStringList;
    protected final int[] permutation;

    public Object get(int index) {
        return this.frontCodedStringList.get(this.permutation[index]);
    }

    public void get(int index, MutableString s) {
        this.frontCodedStringList.get(this.permutation[index], s);
    }

    public int size() {
        return this.frontCodedStringList.size();
    }

    public ObjectListIterator objectListIterator(int k) {
        return new AbstractObjectListIterator(this){
            final IntListIterator i;
            final /* synthetic */ PermutedFrontCodedStringList this$0;

            public final boolean hasNext() {
                return this.i.hasNext();
            }

            public final boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public final Object next() {
                return this.this$0.frontCodedStringList.get(this.this$0.permutation[this.i.nextInt()]);
            }

            public final Object previous() {
                return this.this$0.frontCodedStringList.get(this.this$0.permutation[this.i.previousInt()]);
            }

            public final int nextIndex() {
                return this.i.nextIndex();
            }

            public final int previousIndex() {
                return this.i.previousIndex();
            }

            private final /* synthetic */ void this() {
                this.i = IntIterators.fromTo((int)0, (int)this.this$0.frontCodedStringList.size());
            }
            {
                this.this$0 = permutedFrontCodedStringList;
                this.this();
            }
        };
    }

    public static void main(String[] arg) throws FileNotFoundException, IOException, ClassNotFoundException {
        int[] permutation;
        int ch;
        String listName = null;
        String permutationName = null;
        String permutedListName = null;
        boolean invert = false;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("invert", 0, null, 105)};
        Getopt g = new Getopt("PermutedFrontCodedStringList", arg, "hi", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            switch (ch) {
                case 104: {
                    System.err.println("Usage: PermutedFrontCodedStringList [OPTIONS] LIST PERMUTATION PERMUTEDLIST");
                    System.err.println("Builds a permuted front-coded list of strings using a given front-coded");
                    System.err.println("string list and permutation.");
                    System.err.println();
                    System.err.println("Mandatory arguments:");
                    System.err.println("  LIST                     a front-coded string list");
                    System.err.println("  PERMUTATION              a permutation for the indices of the list");
                    System.err.println("  PERMUTEDLIST             the filename for the resulting permuted list");
                    System.err.println();
                    System.err.println("Optional arguments:");
                    System.err.println("  -i, --invert             invert PERMUTATION before creating the permuted list");
                    System.err.println("");
                    System.err.println("Help:");
                    System.err.println("  -h, --help               print this help screen");
                    System.err.println();
                    return;
                }
                case 105: {
                    invert = true;
                    break;
                }
                case 63: {
                    return;
                }
            }
        }
        if (arg.length - g.getOptind() != 3) {
            System.err.println("Wrong number (" + (arg.length - g.getOptind()) + ") of arguments.");
            return;
        }
        listName = arg[g.getOptind()];
        permutationName = arg[g.getOptind() + 1];
        permutedListName = arg[g.getOptind() + 2];
        int[] basePermutation = Fast.loadInts(permutationName);
        if (invert) {
            int i = basePermutation.length;
            permutation = new int[i];
            while (i-- != 0) {
                permutation[basePermutation[i]] = i;
            }
        } else {
            permutation = basePermutation;
        }
        basePermutation = null;
        Fast.storeObject(new PermutedFrontCodedStringList((FrontCodedStringList)Fast.loadObject(listName), permutation), permutedListName);
    }

    public PermutedFrontCodedStringList(FrontCodedStringList frontCodedStringList, int[] permutation) {
        this.frontCodedStringList = frontCodedStringList;
        this.permutation = permutation;
    }
}

