/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.fastutil.bytes.ByteArrayFrontCodedList;
import it.unimi.dsi.fastutil.chars.CharArrayFrontCodedList;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FrontCodedStringList
extends AbstractObjectList
implements Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected ObjectList frontCodedList;
    protected transient ByteArrayFrontCodedList byteFrontCodedList;
    protected transient CharArrayFrontCodedList charFrontCodedList;
    protected boolean utf8;

    public boolean utf8() {
        return this.utf8;
    }

    public int ratio() {
        return this.utf8 ? this.byteFrontCodedList.ratio() : this.charFrontCodedList.ratio();
    }

    public Object get(int index) {
        return MutableString.wrap(this.utf8 ? FrontCodedStringList.byte2Char(this.byteFrontCodedList.getArray(index), null) : this.charFrontCodedList.getArray(index));
    }

    public void get(int index, MutableString s) {
        if (this.utf8) {
            byte[] a = this.byteFrontCodedList.getArray(index);
            s.length(FrontCodedStringList.countUTF8Chars(a));
            FrontCodedStringList.byte2Char(a, s.array());
        } else {
            int res = this.charFrontCodedList.get(index, s.array);
            if (res < 0) {
                s.length(s.array.length - res);
                res = this.charFrontCodedList.get(index, s.array);
            } else {
                s.length(res);
            }
        }
    }

    private static final int countUTF8Chars(byte[] a) {
        int length = a.length;
        int result = 0;
        int i = 0;
        while (i < length) {
            int b = (a[i] & 0xFF) >> 4;
            if (b < 8) {
                ++result;
            } else if (b < 14) {
                ++result;
                ++i;
            } else {
                ++result;
                i += 2;
            }
            ++i;
        }
        return result;
    }

    private static final char[] byte2Char(byte[] a, char[] s) {
        int length = a.length;
        if (s == null) {
            s = new char[FrontCodedStringList.countUTF8Chars(a)];
        }
        int i = 0;
        int j = 0;
        while (i < length) {
            int c;
            int b = a[i] & 0xFF;
            if (b >> 4 < 8) {
                s[j++] = (char)b;
            } else if (b >> 4 < 14) {
                if (((c = a[++i] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0x1F) << 6 | c & 0x3F);
            } else {
                c = a[++i] & 0xFF;
                byte d = a[++i];
                if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | d & 0x3F);
            }
            ++i;
        }
        return s;
    }

    public ObjectListIterator objectListIterator(int k) {
        return new AbstractObjectListIterator(this, k){
            ObjectListIterator i;
            final /* synthetic */ FrontCodedStringList this$0;
            final /* synthetic */ int val$k;

            public final boolean hasNext() {
                return this.i.hasNext();
            }

            public final boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public final Object next() {
                return MutableString.wrap(this.this$0.utf8 ? FrontCodedStringList.access$0((byte[])this.i.next(), null) : (char[])this.i.next());
            }

            public final Object previous() {
                return MutableString.wrap(this.this$0.utf8 ? FrontCodedStringList.access$0((byte[])this.i.next(), null) : (char[])this.i.previous());
            }

            public final int nextIndex() {
                return this.i.nextIndex();
            }

            public final int previousIndex() {
                return this.i.previousIndex();
            }

            private final /* synthetic */ void this() {
                this.i = this.this$0.frontCodedList.objectListIterator(this.val$k);
            }
            {
                this.this$0 = frontCodedStringList;
                this.val$k = n;
                this.this();
            }
        };
    }

    public int size() {
        return this.frontCodedList.size();
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.utf8) {
            this.byteFrontCodedList = (ByteArrayFrontCodedList)this.frontCodedList;
        } else {
            this.charFrontCodedList = (CharArrayFrontCodedList)this.frontCodedList;
        }
    }

    public static void main(String[] arg) throws FileNotFoundException, IOException {
        int ch;
        String listName = null;
        String encoding = null;
        String bufferSizeSpec = "64Ki";
        int ratio = 4;
        boolean utf8 = false;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("buffer-size", 1, null, 98), new LongOpt("encoding", 1, null, 101), new LongOpt("ratio", 1, null, 114), new LongOpt("utf8", 0, null, 117)};
        Getopt g = new Getopt("FrontCodedStringList", arg, "b:e:r:hu", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            switch (ch) {
                case 104: {
                    System.err.println("Usage: FrontCodedStringList [OPTIONS] LISTNAME");
                    System.err.println("Builds a front-coded list of strings reading from standard input a");
                    System.err.println("newline-separated list of words.");
                    System.err.println();
                    System.err.println("Mandatory arguments:");
                    System.err.println("  LISTNAME                a filename for the list");
                    System.err.println();
                    System.err.println("Optional arguments:");
                    System.err.println("  -b, --buffer-size        the size of I/O buffer (default: " + bufferSizeSpec + ')');
                    System.err.println("  -e, --encoding ENCNAME   a character encoding used to read words");
                    System.err.println("                           (default: the platform default encoding)");
                    System.err.println("  -r, --ratio RATIO        the compression ratio (default: " + ratio + ')');
                    System.err.println("  -u, --utf8               keep the strings as UTF-8 byte arrays");
                    System.err.println("");
                    System.err.println("Help:");
                    System.err.println("  -h, --help               print this help screen");
                    System.err.println();
                    return;
                }
                case 101: {
                    encoding = g.getOptarg();
                    break;
                }
                case 117: {
                    utf8 = true;
                    break;
                }
                case 114: {
                    ratio = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 98: {
                    bufferSizeSpec = g.getOptarg();
                    break;
                }
                case 63: {
                    return;
                }
            }
        }
        int bufferSize = Fast.parseIntSize(bufferSizeSpec);
        if (arg.length - g.getOptind() != 1) {
            System.err.println("Wrong number (" + (arg.length - g.getOptind()) + ") of arguments.");
            return;
        }
        listName = arg[g.getOptind()];
        FastBufferedReader words = encoding != null ? new FastBufferedReader(new InputStreamReader(System.in, encoding), bufferSize) : new FastBufferedReader(new InputStreamReader(System.in), bufferSize);
        System.err.print("Reading words...");
        ProgressMeter pm = new ProgressMeter(100000, "words");
        pm.start();
        FrontCodedStringList p = new FrontCodedStringList((Iterator)new AbstractObjectIterator(words, pm){
            MutableString s;
            MutableString next;
            boolean toAdvance;
            final /* synthetic */ FastBufferedReader val$words;
            final /* synthetic */ ProgressMeter val$pm;

            public final boolean hasNext() {
                if (this.toAdvance) {
                    try {
                        this.next = this.val$words.readLine(this.s);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.toAdvance = false;
                }
                boolean bl = false;
                if (this.next != null) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.toAdvance = true;
                this.val$pm.update();
                return new MutableString(this.s);
            }

            private final /* synthetic */ void this() {
                this.s = new MutableString();
                this.toAdvance = true;
            }
            {
                this.val$words = fastBufferedReader;
                this.val$pm = progressMeter;
                this.this();
            }
        }, ratio, utf8);
        pm.done();
        System.err.print("Writing to file...");
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(listName), bufferSize));
        out.writeObject(p);
        out.close();
        System.err.println(" done.");
    }

    static final /* synthetic */ char[] access$0(byte[] byArray, char[] cArray) {
        return FrontCodedStringList.byte2Char(byArray, cArray);
    }

    public FrontCodedStringList(Iterator words, int ratio, boolean utf8) {
        ByteArrayFrontCodedList byteArrayFrontCodedList;
        this.utf8 = utf8;
        if (utf8) {
            byteArrayFrontCodedList = this.byteFrontCodedList = new ByteArrayFrontCodedList((Iterator)new AbstractObjectIterator(this, words){
                final /* synthetic */ FrontCodedStringList this$0;
                final /* synthetic */ Iterator val$words;

                public final boolean hasNext() {
                    return this.val$words.hasNext();
                }

                public final Object next() {
                    try {
                        return ((CharSequence)this.val$words.next()).toString().getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException cantHappen) {
                        return null;
                    }
                }
                {
                    this.this$0 = frontCodedStringList;
                    this.val$words = iterator;
                }
            }, ratio);
        } else {
            this.charFrontCodedList = new CharArrayFrontCodedList((Iterator)new AbstractObjectIterator(this, words){
                final /* synthetic */ FrontCodedStringList this$0;
                final /* synthetic */ Iterator val$words;

                public final boolean hasNext() {
                    return this.val$words.hasNext();
                }

                public final Object next() {
                    CharSequence s = (CharSequence)this.val$words.next();
                    int i = s.length();
                    char[] a = new char[i];
                    while (i-- != 0) {
                        a[i] = s.charAt(i);
                    }
                    return a;
                }
                {
                    this.this$0 = frontCodedStringList;
                    this.val$words = iterator;
                }
            }, ratio);
            byteArrayFrontCodedList = this.charFrontCodedList;
        }
        this.frontCodedList = byteArrayFrontCodedList;
    }

    public FrontCodedStringList(Collection c, int ratio, boolean utf8) {
        this(c.iterator(), ratio, utf8);
    }
}

