/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.SkipIndexWriter;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.tool.Occurrence;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;

public final class SecondPass
implements CompressionFlags {
    private static final boolean ASSERTS = false;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$IndexWriter;
    private static final /* synthetic */ boolean $noassert;

    public static final void main(String[] arg) {
        int ch;
        int writerFlags = 0;
        int quantum = 64;
        int height = 8;
        MutableString writerFlagsString = new MutableString();
        boolean computeFrequencies = false;
        boolean skips = false;
        String bufferSizeSpec = "1Mi";
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("buffer-size", 1, null, 98), new LongOpt("comp", 1, null, 99), new LongOpt("quantum", 1, null, 81), new LongOpt("height", 1, null, 72), new LongOpt("compute-frequencies", 0, null, 102)};
        Getopt g = new Getopt("SecondPass", arg, "fQ:H:b:hc:", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            switch (ch) {
                case 104: {
                    System.err.println("Usage: SecondPass [OPTIONS] BASENAME");
                    System.err.println("Builds an inverted index from a set of batches.");
                    System.err.println("");
                    System.err.println("Mandatory arguments:");
                    System.err.println("  BASENAME    all file names will be stemmed from this name");
                    System.err.println("");
                    System.err.println("Optional arguments:");
                    System.err.println("  -b, --buffer-size          the size of an I/O buffer (default: " + bufferSizeSpec + ')');
                    System.err.println("  -c, --comp                 a compression flag for the index (may be specified several times).");
                    System.err.println("  -f, --compute-frequencies  compute frequencies from batches.");
                    System.err.println("  -Q, --quantum              enable skips with given quantum (default: " + quantum + ").");
                    System.err.println("  -H, --height               enable skips with given height (default: " + height + ").");
                    System.err.println("");
                    System.err.println("Help:");
                    System.err.println("  -h, --help        print this help screen");
                    System.err.println("");
                    return;
                }
                case 98: {
                    bufferSizeSpec = g.getOptarg();
                    break;
                }
                case 102: {
                    computeFrequencies = true;
                    break;
                }
                case 81: {
                    quantum = Integer.parseInt(g.getOptarg());
                    if (quantum <= 0) {
                        System.err.println("Invalid quantum: " + quantum);
                        return;
                    }
                    skips = true;
                    break;
                }
                case 72: {
                    height = Integer.parseInt(g.getOptarg());
                    if (height < 0) {
                        System.err.println("Invalid height: " + height);
                        return;
                    }
                    skips = true;
                    break;
                }
                case 99: {
                    try {
                        long l = writerFlags;
                        Class clazz = class$it$unimi$dsi$mg4j$index$IndexWriter;
                        if (clazz == null) {
                            clazz = SecondPass.class$("[Lit.unimi.dsi.mg4j.index.IndexWriter;", false);
                        }
                        Field field = clazz.getField(g.getOptarg());
                        Class clazz2 = class$it$unimi$dsi$mg4j$index$IndexWriter;
                        if (clazz2 == null) {
                            clazz2 = SecondPass.class$("[Lit.unimi.dsi.mg4j.index.IndexWriter;", false);
                        }
                        writerFlags = (int)(l | field.getLong(clazz2));
                        if (writerFlagsString.length() != 0) {
                            writerFlagsString.append(" | ");
                        }
                        writerFlagsString.append(g.getOptarg());
                        break;
                    }
                    catch (Exception notFound) {
                        System.err.println("Compression method " + g.getOptarg() + " unknown.");
                        return;
                    }
                }
                case 63: {
                    return;
                }
            }
        }
        int bufferSize = Fast.parseIntSize(bufferSizeSpec);
        if (arg.length - g.getOptind() != 1) {
            System.err.println("Wrong number (" + (arg.length - g.getOptind()) + ") of arguments.");
            return;
        }
        String baseName = arg[g.getOptind()] + '.';
        try {
            FileInputStream propertyFile = new FileInputStream(baseName + "properties");
            Properties properties = new Properties();
            properties.load(propertyFile);
            propertyFile.close();
            int N = Integer.parseInt(properties.getProperty("documents"));
            int numTerms = Integer.parseInt(properties.getProperty("terms"));
            int numBatches = Integer.parseInt(properties.getProperty("batches"));
            long numOccurrences = Long.parseLong(properties.getProperty("occurrences"));
            int[] size = new int[N];
            double averageSize = 0.0;
            InputBitStream sizes = new InputBitStream(new FileInputStream(baseName + "sizes"), bufferSize);
            int i = 0;
            while (i < N) {
                size[i] = sizes.readGamma();
                averageSize += (double)size[i];
                ++i;
            }
            sizes.close();
            averageSize /= (double)N;
            Object[] occurrence = new Occurrence[numBatches];
            InputBitStream[] fibs = new InputBitStream[numBatches];
            int[] occInDoc = new int[16384];
            int[] numOcc = new int[numBatches];
            int[] currTerm = new int[numBatches];
            int[] currDocument = new int[numBatches];
            int[] currPosition = new int[numBatches];
            int numPosInDoc = 0;
            int prevTermIndex = -1;
            int prevDocIndex = -1;
            int freqClass = 0;
            int maxDocPos = 0;
            long[] bitsForPointers = new long[10];
            long[] bitsForPositions = new long[10];
            long termOccurrences = 0L;
            long numPointers = 0L;
            long[] pointersByFrequency = new long[10];
            long[] occurrencesByFrequency = new long[10];
            OutputBitStream index = new OutputBitStream(new FileOutputStream(baseName + "index"), bufferSize);
            OutputBitStream offsets = new OutputBitStream(new FileOutputStream(baseName + "offsets"));
            IndexWriter indexWriter = skips ? new SkipIndexWriter(index, offsets, N, writerFlags, quantum, height) : new IndexWriter(index, offsets, N, (long)writerFlags);
            InputBitStream frequencies = null;
            properties.setProperty("compressionflags", writerFlagsString.toString());
            if (skips) {
                properties.setProperty("skipquantum", String.valueOf(quantum));
                properties.setProperty("skipheight", String.valueOf(height));
            } else {
                properties.remove("skipquantum");
                properties.remove("skipheight");
            }
            OutputBitStream termOccs = new OutputBitStream(new FileOutputStream(baseName + "globcounts"));
            ProgressMeter pm = new ProgressMeter(10, "batches");
            pm.start();
            while (true) {
                int batch = numBatches;
                System.err.print("Initialising batches...");
                ObjectHeapSemiIndirectPriorityQueue queue = new ObjectHeapSemiIndirectPriorityQueue(occurrence, numBatches);
                i = 0;
                while (i < batch) {
                    fibs[i] = new InputBitStream(new FileInputStream(baseName + "batch" + i), bufferSize);
                    numOcc[i] = fibs[i].readDelta();
                    int n = i;
                    numOcc[n] = numOcc[n] - 1;
                    currTerm[i] = fibs[i].readDelta();
                    currDocument[i] = fibs[i].readDelta();
                    currPosition[i] = fibs[i].readDelta();
                    occurrence[i] = new Occurrence(currTerm[i], currDocument[i], currPosition[i]);
                    queue.enqueue(i);
                    pm.update();
                    ++i;
                }
                pm.done();
                if (!computeFrequencies) {
                    frequencies = new InputBitStream(new FileInputStream(baseName + "frequencies"));
                }
                if (computeFrequencies) {
                    System.err.print("Computing frequencies...");
                } else {
                    System.err.print("Merging batches...");
                }
                long j = numOccurrences + 1L;
                int[] freq = null;
                if (computeFrequencies) {
                    freq = new int[numTerms];
                }
                pm.quantum(1000000);
                pm.itemsName("Koccurrences");
                pm.start();
                pm.expectedUpdates(numOccurrences / 1000L);
                if (numOccurrences > 0L) {
                    while (j-- != 0L) {
                        int currBatch = queue.first();
                        Object curr = occurrence[currBatch];
                        if (j % 1000L == 0L) {
                            pm.update();
                        }
                        if (computeFrequencies) {
                            if ((((Occurrence)curr).docIndex != prevDocIndex || ((Occurrence)curr).termIndex != prevTermIndex) && prevTermIndex != -1) {
                                int n = prevTermIndex;
                                freq[n] = freq[n] + 1;
                            }
                            prevTermIndex = ((Occurrence)curr).termIndex;
                            prevDocIndex = ((Occurrence)curr).docIndex;
                        } else {
                            if (((Occurrence)curr).docIndex != prevDocIndex || ((Occurrence)curr).termIndex != prevTermIndex) {
                                if (numPosInDoc != 0) {
                                    OutputBitStream obs = indexWriter.newDocumentRecord();
                                    int n = freqClass;
                                    bitsForPointers[n] = bitsForPointers[n] + (long)indexWriter.writeDocumentPointer(obs, prevDocIndex);
                                    termOccurrences += (long)numPosInDoc;
                                    if (numPosInDoc > maxDocPos) {
                                        maxDocPos = numPosInDoc;
                                    }
                                    if (indexWriter.hasCounts) {
                                        indexWriter.writePositionCount(obs, numPosInDoc);
                                        if (indexWriter.hasPositions) {
                                            int n2 = freqClass;
                                            bitsForPositions[n2] = bitsForPositions[n2] + (long)indexWriter.writeDocumentPositions(obs, occInDoc, 0, numPosInDoc, size[prevDocIndex]);
                                        }
                                    }
                                }
                                if (((Occurrence)curr).termIndex != prevTermIndex) {
                                    if (prevTermIndex != -1) {
                                        termOccs.writeLongGamma(termOccurrences);
                                        int n = freqClass;
                                        occurrencesByFrequency[n] = occurrencesByFrequency[n] + termOccurrences;
                                    }
                                    if (((Occurrence)curr).termIndex != -1) {
                                        int frequency = frequencies.readGamma();
                                        numPointers += (long)frequency;
                                        int n = freqClass = (int)((double)(10 * frequency) / (double)(N + 1));
                                        pointersByFrequency[n] = pointersByFrequency[n] + (long)frequency;
                                        indexWriter.newInvertedList();
                                        indexWriter.writeFrequency(frequency);
                                        termOccurrences = 0L;
                                    }
                                }
                                numPosInDoc = 0;
                            }
                            if (numPosInDoc >= occInDoc.length) {
                                occInDoc = IntArrays.grow((int[])occInDoc, (int)(numPosInDoc + 1));
                            }
                            occInDoc[numPosInDoc++] = ((Occurrence)curr).docPosition;
                        }
                        prevTermIndex = ((Occurrence)curr).termIndex;
                        prevDocIndex = ((Occurrence)curr).docIndex;
                        if (numOcc[currBatch] != 0) {
                            int n = currBatch;
                            numOcc[n] = numOcc[n] - 1;
                            int termIndexDelta = fibs[currBatch].readUnary();
                            int docIndexDelta = fibs[currBatch].readDelta();
                            int docPositionDelta = fibs[currBatch].readDelta();
                            if (termIndexDelta != 0) {
                                currDocument[currBatch] = 0;
                                currPosition[currBatch] = -1;
                            }
                            if (docIndexDelta != 0) {
                                currPosition[currBatch] = -1;
                            }
                            int n3 = currBatch;
                            int n4 = currTerm[n3] + termIndexDelta;
                            currTerm[n3] = n4;
                            ((Occurrence)curr).termIndex = n4;
                            int n5 = currBatch;
                            int n6 = currDocument[n5] + docIndexDelta;
                            currDocument[n5] = n6;
                            ((Occurrence)curr).docIndex = n6;
                            int n7 = currBatch;
                            int n8 = currPosition[n7] + (docPositionDelta + 1);
                            currPosition[n7] = n8;
                            ((Occurrence)curr).docPosition = n8;
                            queue.changed();
                            continue;
                        }
                        queue.dequeue();
                        if (!queue.isEmpty()) continue;
                        ((Occurrence)occurrence[0]).termIndex = -1;
                        queue.enqueue(0);
                    }
                }
                pm.done();
                if (!computeFrequencies) break;
                computeFrequencies = false;
                System.err.print("Writing frequencies...");
                OutputBitStream freqs = new OutputBitStream(new FileOutputStream(baseName + "frequencies"));
                i = 0;
                while (i < numTerms) {
                    freqs.writeGamma(freq[i]);
                    ++i;
                }
                freqs.close();
                System.err.println(" done.");
            }
            indexWriter.close();
            offsets.close();
            frequencies.close();
            termOccs.writeLongGamma(termOccurrences);
            termOccs.close();
            properties.setProperty("maxdocpos", String.valueOf(maxDocPos));
            properties.setProperty("indexclass", "it.unimi.dsi.mg4j.index." + (skips ? "SkipIndex" : "Index"));
            FileOutputStream propertyFile2 = new FileOutputStream(baseName + "properties");
            properties.store(propertyFile2, "SecondPass properties");
            propertyFile2.close();
            System.out.println("Number of documents: " + Fast.format(N));
            System.out.println("Average size: " + Fast.format(averageSize));
            System.out.println("Number of terms: " + Fast.format(numTerms));
            System.out.println("Number of occurrences: " + Fast.format(numOccurrences));
            System.out.println("Frequencies: " + Fast.format(indexWriter.bitsForFrequencies) + " bits, " + Fast.format((double)indexWriter.bitsForFrequencies / (double)numTerms) + " bits/frequency.");
            System.out.println("Document pointers: " + Fast.format(numPointers) + " (" + Fast.format(indexWriter.bitsForPointers) + " bits, " + Fast.format((double)indexWriter.bitsForPointers / (double)numPointers) + " bits/pointer).");
            if (indexWriter.hasCounts) {
                System.out.println("Counts: " + Fast.format(numPointers) + " (" + Fast.format(indexWriter.bitsForCounts) + " bits, " + Fast.format((double)indexWriter.bitsForCounts / (double)numPointers) + " bits/count).");
            }
            if (indexWriter.hasPositions) {
                System.out.println("Occurrences: " + Fast.format(numOccurrences) + " (" + Fast.format(indexWriter.bitsForPositions) + " bits, " + Fast.format((double)indexWriter.bitsForPositions / (double)numOccurrences) + " bits/occurrence).");
            }
            if (skips) {
                SkipIndexWriter s = (SkipIndexWriter)indexWriter;
                System.out.println("Skip towers: " + Fast.format(s.towerData.numberOfSkipTowers) + " (" + Fast.format(s.towerData.bitsForTowers()) + " bits [" + Fast.format((double)s.towerData.bitsForTowers() * 100.0 / (double)s.writtenBits()) + "%], " + Fast.format((double)s.towerData.bitsForTowers() / (double)s.towerData.numberOfSkipTowers) + " bits/tower)");
                System.out.println("Skip entries: " + Fast.format(s.towerData.numberOfSkipEntries) + " (" + Fast.format((double)s.towerData.bitsForEntries() / (double)s.towerData.numberOfSkipEntries) + " bits/entry)");
                System.out.println("Skip tower lengths: " + Fast.format(s.towerData.bitsForTowerLengths) + " bits (" + Fast.format((double)s.towerData.bitsForTowerLengths / (double)s.towerData.numberOfSkipTowers) + " bits/tower)");
                System.out.println("Quantum bit lengths: " + Fast.format(s.bitsForQuantumBitLengths) + " bits (" + Fast.format((double)s.bitsForQuantumBitLengths / (double)s.numberOfBlocks) + " bits/block)");
                System.out.println("Entry bit lengths: " + Fast.format(s.bitsForEntryBitLengths) + " bits (" + Fast.format((double)s.bitsForEntryBitLengths / (double)s.numberOfBlocks) + " bits/block)");
                System.out.println("Top skip amounts: " + Fast.format(s.towerData.bitsForTopSkipAmounts) + " bits (" + Fast.format((double)s.towerData.bitsForTopSkipAmounts / (double)s.towerData.numberOfSkipTowers) + " bits/amount)");
                System.out.println("Top skip pointers: " + Fast.format(s.towerData.bitsForTopSkipPointers) + " bits (" + Fast.format((double)s.towerData.bitsForTopSkipPointers / (double)s.towerData.numberOfSkipTowers) + " bits/pointer)");
                System.out.println("Lower skip amounts: " + Fast.format(s.towerData.bitsForLowerSkipAmounts) + " bits (" + Fast.format((double)s.towerData.bitsForLowerSkipAmounts / (double)s.towerData.numberOfLowerEntries()) + " bits/amount)");
                System.out.println("Lower skip pointers: " + Fast.format(s.towerData.bitsForLowerSkipPointers) + " bits (" + Fast.format((double)s.towerData.bitsForLowerSkipPointers / (double)s.towerData.numberOfLowerEntries()) + " bits/pointer)");
                System.out.println("Skip amounts: " + Fast.format(s.towerData.bitsForSkipAmounts()) + " bits (" + Fast.format((double)s.towerData.bitsForSkipAmounts() / (double)s.towerData.numberOfSkipEntries) + " bits/amount)");
                System.out.println("Skip pointers: " + Fast.format(s.towerData.bitsForSkipPointers()) + " bits (" + Fast.format((double)s.towerData.bitsForSkipPointers() / (double)s.towerData.numberOfSkipEntries) + " bits/pointer)");
            }
            System.out.println("Alignment: " + Fast.format(indexWriter.bitsForAlignment) + " bits, " + Fast.format((double)indexWriter.bitsForAlignment / (double)numTerms) + " bits/alignment.");
            if (indexWriter.hasPositions) {
                System.out.println("Total: " + Fast.format(indexWriter.writtenBits()) + " bits, " + Fast.format((double)indexWriter.writtenBits() / (double)numOccurrences) + " bits/occurrence");
            } else {
                System.out.println("Total: " + Fast.format(indexWriter.writtenBits()) + " bits, " + Fast.format((double)indexWriter.writtenBits() / (double)numOccurrences) + " bits/pointer");
            }
            System.out.println();
            System.out.println("Number of pointers by frequency:");
            i = 0;
            while (i < 10) {
                System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)pointersByFrequency[i] / (double)numPointers) + '%');
                ++i;
            }
            System.out.println();
            System.out.println("Number of occurrences by frequency:");
            i = 0;
            while (i < 10) {
                System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)occurrencesByFrequency[i] / (double)numOccurrences) + '%');
                ++i;
            }
            System.out.println();
            System.out.println("Number of bits for pointers by frequency:");
            i = 0;
            while (i < 10) {
                System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)bitsForPointers[i] / (double)indexWriter.bitsForPointers) + '%');
                ++i;
            }
            System.out.println();
            if (indexWriter.hasPositions) {
                System.out.println("Number of bits for occurrences by frequency:");
                i = 0;
                while (i < 10) {
                    System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)bitsForPositions[i] / (double)indexWriter.bitsForPositions) + '%');
                    ++i;
                }
            }
        }
        catch (IOException dontCare) {
            dontCare.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private SecondPass() {
    }

    static {
        $noassert = Class.forName("[Lit.unimi.dsi.mg4j.tool.SecondPass;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

