/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import java.io.IOException;

public class Occurrence
implements Comparable {
    public int termIndex;
    public int docIndex;
    public int docPosition;

    public void set(int termIndex, int docIndex, int docPosition) {
        this.termIndex = termIndex;
        this.docIndex = docIndex;
        this.docPosition = docPosition;
    }

    public int hashCode() {
        return this.termIndex ^ this.docIndex ^ this.docPosition;
    }

    public boolean equals(Object o) {
        if (o instanceof Occurrence) {
            Occurrence occ = (Occurrence)o;
            boolean bl = false;
            if (this.termIndex == occ.termIndex && this.docIndex == occ.docIndex && this.docPosition == occ.docPosition) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object o) {
        Occurrence occ = (Occurrence)o;
        int t = this.termIndex - occ.termIndex;
        if (t != 0) {
            return t;
        }
        t = this.docIndex - occ.docIndex;
        if (t != 0) {
            return t;
        }
        return this.docPosition - occ.docPosition;
    }

    public String toString() {
        return "[termIndex: " + this.termIndex + " docIndex: " + this.docIndex + " docPosition: " + this.docPosition + ']';
    }

    public static void countSortOnTerms(Occurrence[] in, Occurrence[] out, int len, int[] count, int n) {
        Occurrence[] s = in;
        Occurrence[] t = out;
        int[] c = count;
        IntArrays.fill((int[])c, (int)0, (int)n, (int)0);
        int i = len;
        while (i-- != 0) {
            int n2 = s[i].termIndex;
            c[n2] = c[n2] + 1;
        }
        i = 1;
        while (i < n) {
            int n3 = i;
            c[n3] = c[n3] + c[i - 1];
            ++i;
        }
        i = len;
        while (i-- != 0) {
            int n4 = s[i].termIndex;
            int n5 = c[n4] - 1;
            c[n4] = n5;
            t[n5] = s[i];
        }
    }

    public static void countSortOnDocuments(Occurrence[] in, Occurrence[] out, int len, int[] count, int n) {
        Occurrence[] s = in;
        Occurrence[] t = out;
        int[] c = count;
        IntArrays.fill((int[])c, (int)0, (int)n, (int)0);
        int i = len;
        while (i-- != 0) {
            int n2 = s[i].docIndex;
            c[n2] = c[n2] + 1;
        }
        i = 1;
        while (i < n) {
            int n3 = i;
            c[n3] = c[n3] + c[i - 1];
            ++i;
        }
        i = len;
        while (i-- != 0) {
            int n4 = s[i].docIndex;
            int n5 = c[n4] - 1;
            c[n4] = n5;
            t[n5] = s[i];
        }
    }

    public static void writeOccurrences(Occurrence[] occurrence, int len, OutputBitStream out) throws IOException {
        int i = 0;
        out.writeDelta(len);
        out.writeDelta(occurrence[0].termIndex);
        out.writeDelta(occurrence[0].docIndex);
        out.writeDelta(occurrence[0].docPosition);
        Occurrence curr = occurrence[0];
        i = 1;
        while (i < len) {
            Occurrence prev = curr;
            curr = occurrence[i];
            out.writeUnary(curr.termIndex - prev.termIndex);
            if (curr.termIndex == prev.termIndex) {
                out.writeDelta(curr.docIndex - prev.docIndex);
                if (curr.docIndex == prev.docIndex) {
                    out.writeDelta(curr.docPosition - prev.docPosition - 1);
                } else {
                    out.writeDelta(curr.docPosition);
                }
            } else {
                out.writeDelta(curr.docIndex);
                out.writeDelta(curr.docPosition);
            }
            ++i;
        }
    }

    public static int readOccurrences(Occurrence[] occurrence, int len, InputBitStream in) throws IOException {
        int l = Math.min(Math.min(len, in.readDelta()), occurrence.length);
        if (l == 0) {
            return l;
        }
        int curTermIndex = in.readDelta();
        int curDocIndex = in.readDelta();
        int curDocPosition = in.readDelta();
        occurrence[0].set(curTermIndex, curDocIndex, curDocPosition);
        int i = 1;
        while (i < l) {
            int termIndexDelta = in.readUnary();
            int docIndexDelta = in.readDelta();
            int docPositionDelta = in.readDelta();
            if (termIndexDelta != 0) {
                curDocIndex = 0;
                curDocPosition = -1;
            }
            if (docIndexDelta != 0) {
                curDocPosition = -1;
            }
            occurrence[i].set(curTermIndex += termIndexDelta, curDocIndex += docIndexDelta, curDocPosition += docPositionDelta + 1);
            ++i;
        }
        return l;
    }

    public Occurrence() {
    }

    public Occurrence(int termIndex, int docIndex, int docPosition) {
        this.set(termIndex, docIndex, docPosition);
    }
}

