/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.tool.Occurrence;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import jal.ints.BinaryPredicate;
import jal.ints.Sorting;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;

public final class MiddlePass {
    static String[] term;

    public static final void main(String[] arg) throws IOException {
        int ch;
        String bufferSizeSpec = "1Mi";
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("buffer-size", 1, null, 98)};
        Getopt g = new Getopt("MiddlePass", arg, "b:h", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            switch (ch) {
                case 104: {
                    System.err.println("Usage: MiddlePass [OPTIONS] BASENAME");
                    System.err.println("Permutes a set of batches so that terms are ordered lexicographically.");
                    System.err.println("");
                    System.err.println("Mandatory arguments:");
                    System.err.println("  BASENAME\tall file names will be stemmed from this name");
                    System.err.println("");
                    System.err.println("Optional arguments:");
                    System.err.println("  -b, --buffer-size the size of an I/O buffer (default: " + bufferSizeSpec + ')');
                    System.err.println("");
                    System.err.println("Help:");
                    System.err.println("  -h, --help\t\tprint this help screen");
                    System.err.println("");
                    return;
                }
                case 98: {
                    bufferSizeSpec = g.getOptarg();
                    break;
                }
                case 63: {
                    return;
                }
            }
        }
        int bufferSize = Fast.parseIntSize(bufferSizeSpec);
        if (arg.length - g.getOptind() != 1) {
            System.err.println("Wrong number (" + (arg.length - g.getOptind()) + ") of arguments.");
            return;
        }
        String baseName = arg[g.getOptind()] + '.';
        FileInputStream propertyFile = new FileInputStream(baseName + "properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        int numTerms = Integer.parseInt(properties.getProperty("terms"));
        int numBatches = Integer.parseInt(properties.getProperty("batches"));
        int occsPerBatch = Integer.parseInt(properties.getProperty("occsperbatch"));
        Occurrence[] occurrence = new Occurrence[occsPerBatch];
        Occurrence[] sortedOccurrence = new Occurrence[occsPerBatch];
        System.err.print("Reading terms... ");
        term = new String[numTerms];
        BufferedReader terms = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(baseName + "terms"), "UTF-8"), bufferSize);
        int i = 0;
        while (i < numTerms) {
            MiddlePass.term[i] = terms.readLine();
            ++i;
        }
        terms.close();
        int[] perm = new int[numTerms];
        i = numTerms;
        while (i-- != 0) {
            perm[i] = i;
        }
        System.err.print("sorting terms... ");
        Sorting.sort((int[])perm, (int)0, (int)perm.length, (BinaryPredicate)new TermPredicate());
        System.err.print("saving sorted terms... ");
        PrintWriter sortedTerms = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(baseName + "terms"), "UTF-8"), bufferSize));
        i = 0;
        while (i < numTerms) {
            sortedTerms.println(term[perm[i]]);
            ++i;
        }
        sortedTerms.close();
        term = null;
        int[] count = new int[numTerms + 1];
        if (new File(baseName + "frequencies").exists()) {
            System.err.print("reading frequencies... ");
            InputBitStream frequencies = new InputBitStream(new FileInputStream(baseName + "frequencies"), bufferSize);
            i = 0;
            while (i < numTerms) {
                count[i] = frequencies.readGamma();
                ++i;
            }
            frequencies.close();
            System.err.print("writing frequencies... ");
            OutputBitStream sortedFrequencies = new OutputBitStream(new FileOutputStream(baseName + "frequencies"), bufferSize);
            i = 0;
            while (i < numTerms) {
                sortedFrequencies.writeGamma(count[perm[i]]);
                ++i;
            }
            sortedFrequencies.close();
        } else {
            System.err.print("(no frequencies)...");
        }
        System.err.print("creating occurrences... ");
        i = occsPerBatch;
        while (i-- != 0) {
            occurrence[i] = new Occurrence();
        }
        System.err.println(" done.");
        int[] temp = new int[numTerms];
        i = numTerms;
        while (i-- != 0) {
            temp[perm[i]] = i;
        }
        System.arraycopy(temp, 0, perm, 0, numTerms);
        temp = null;
        ProgressMeter pm = new ProgressMeter(10, "batches");
        System.err.print("Permuting batches...");
        pm.start();
        i = 0;
        while (i < numBatches) {
            InputBitStream in = new InputBitStream(new FileInputStream(baseName + "batch" + i), bufferSize);
            int l = Occurrence.readOccurrences(occurrence, occsPerBatch, in);
            in.close();
            int j = l;
            while (j-- != 0) {
                occurrence[j].termIndex = perm[occurrence[j].termIndex];
            }
            Occurrence.countSortOnTerms(occurrence, sortedOccurrence, l, count, numTerms);
            OutputBitStream out = new OutputBitStream(new FileOutputStream(baseName + "batch" + i), bufferSize);
            Occurrence.writeOccurrences(sortedOccurrence, l, out);
            out.close();
            pm.update();
            ++i;
        }
        pm.done();
    }

    private MiddlePass() {
    }

    private static class TermPredicate
    implements BinaryPredicate {
        public boolean apply(int x, int y) {
            boolean bl = false;
            if (term[x].compareTo(term[y]) < 0) {
                bl = true;
            }
            return bl;
        }

        private TermPredicate() {
        }
    }
}

