/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.SkipIndexWriter;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Properties;

public final class Merge
implements CompressionFlags {
    private static final String THIS_CLASS_NAME = new Merge().getClass().getName();
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$IndexWriter;

    public static final void main(String[] arg) throws IOException {
        int ch;
        int writerFlags = 0;
        int quantum = 64;
        int height = 8;
        MutableString writerFlagsString = new MutableString();
        boolean skips = false;
        String bufferSizeSpec = "1Mi";
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("buffer-size", 1, null, 98), new LongOpt("comp", 1, null, 99), new LongOpt("quantum", 1, null, 81), new LongOpt("height", 1, null, 72)};
        Getopt g = new Getopt(THIS_CLASS_NAME, arg, "Q:H:b:hc:", longopts);
        g.setOpterr(true);
        while ((ch = g.getopt()) != -1) {
            switch (ch) {
                case 104: {
                    System.err.println("Usage: " + THIS_CLASS_NAME + " [OPTIONS] OUTPUTBASENAME INPUTBASENAME ...");
                    System.err.println("Merges several indices.");
                    System.err.println("");
                    System.err.println("Mandatory arguments:");
                    System.err.println("  OUTPUTBASENAME      basename of the merged index");
                    System.err.println("  INPUTBASENAME ...   basenames of the indices to be merged");
                    System.err.println("");
                    System.err.println("Optional arguments:");
                    System.err.println("  -b, --buffer-size          the size of an I/O buffer (default: " + bufferSizeSpec + ')');
                    System.err.println("  -c, --comp                 a compression flags for the index (may be specified several times).");
                    System.err.println("  -Q, --quantum              enable skips with given quantum (default: " + quantum + ").");
                    System.err.println("  -H, --height               enable skips with given height (default: " + height + ").");
                    System.err.println("");
                    System.err.println("Help:");
                    System.err.println("  -h, --help        print this help screen");
                    System.err.println("");
                    System.exit(0);
                }
                case 98: {
                    bufferSizeSpec = g.getOptarg();
                    break;
                }
                case 81: {
                    quantum = Integer.parseInt(g.getOptarg());
                    if (quantum <= 0) {
                        System.err.println("Invalid quantum: " + quantum);
                        return;
                    }
                    skips = true;
                    break;
                }
                case 72: {
                    height = Integer.parseInt(g.getOptarg());
                    if (height < 0) {
                        System.err.println("Invalid height: " + height);
                        return;
                    }
                    skips = true;
                    break;
                }
                case 99: {
                    try {
                        long l = writerFlags;
                        Class clazz = class$it$unimi$dsi$mg4j$index$IndexWriter;
                        if (clazz == null) {
                            clazz = Merge.class$("[Lit.unimi.dsi.mg4j.index.IndexWriter;", false);
                        }
                        Field field = clazz.getField(g.getOptarg());
                        Class clazz2 = class$it$unimi$dsi$mg4j$index$IndexWriter;
                        if (clazz2 == null) {
                            clazz2 = Merge.class$("[Lit.unimi.dsi.mg4j.index.IndexWriter;", false);
                        }
                        writerFlags = (int)(l | field.getLong(clazz2));
                        if (writerFlagsString.length() != 0) {
                            writerFlagsString.append(" | ");
                        }
                        writerFlagsString.append(g.getOptarg());
                        break;
                    }
                    catch (Exception notFound) {
                        System.err.println("Compression method " + g.getOptarg() + " unknown.");
                        return;
                    }
                }
                case 63: {
                    return;
                }
            }
        }
        int bufferSize = Fast.parseIntSize(bufferSizeSpec);
        if (arg.length - g.getOptind() < 2) {
            System.err.println("Wrong number (" + (arg.length - g.getOptind()) + ") of arguments.");
            return;
        }
        int numIndices = arg.length - g.getOptind() - 1;
        String outputBasename = arg[g.getOptind()];
        String[] basename = new String[numIndices];
        Index[] index = new Index[numIndices];
        IndexReader[] indexReader = new IndexReader[numIndices];
        InputBitStream[] globCounts = new InputBitStream[numIndices];
        Object[] term = new MutableString[numIndices];
        FastBufferedReader[] termReader = new FastBufferedReader[numIndices];
        ObjectHeapSemiIndirectPriorityQueue queue = new ObjectHeapSemiIndirectPriorityQueue(term, numIndices);
        ProgressMeter pm = new ProgressMeter(1000000);
        int numberOfDocuments = 0;
        int maxDocPos = 0;
        int numberOfLists = 0;
        boolean hasCounts = true;
        boolean hasPositions = true;
        int i = 0;
        while (i < numIndices) {
            basename[i] = arg[g.getOptind() + 1 + i];
            index[i] = Index.getInstance(basename[i]);
            if (!index[i].hasCounts) {
                hasCounts = false;
            }
            if (!index[i].hasPositions) {
                hasPositions = false;
            }
            maxDocPos = Math.max(maxDocPos, index[i].maxDocPos);
            indexReader[i] = index[i].getReader(bufferSize);
            numberOfDocuments += index[i].numberOfDocuments;
            numberOfLists += index[i].numberOfTerms;
            globCounts[i] = new InputBitStream(basename[i] + ".globcounts");
            term[i] = new MutableString();
            termReader[i] = new FastBufferedReader(new InputStreamReader((InputStream)new FileInputStream(basename[i] + ".terms"), "UTF-8"));
            termReader[i].readLine((MutableString)term[i]);
            if (((MutableString)term[i]).length() != 0) {
                queue.enqueue(i);
            }
            ++i;
        }
        try {
            int j;
            int[] size = new int[numberOfDocuments];
            double averageSize = 0.0;
            OutputBitStream outputSizes = new OutputBitStream(outputBasename + ".sizes", bufferSize);
            pm.quantum(1000000);
            pm.itemsName("ints");
            pm.start("Merging sizes...");
            int maxDocSize = 0;
            int k = 0;
            i = 0;
            while (i < numIndices) {
                InputBitStream sizes = new InputBitStream(basename[i] + ".sizes", bufferSize);
                int s = 0;
                j = index[i].numberOfDocuments;
                while (j-- != 0) {
                    size[k++] = s = sizes.readGamma();
                    if (s > maxDocSize) {
                        maxDocSize = s;
                    }
                    outputSizes.writeGamma(s);
                    averageSize += (double)s;
                }
                sizes.close();
                ++i;
            }
            outputSizes.close();
            pm.done();
            averageSize /= (double)numberOfDocuments;
            OutputBitStream mergedIndex = new OutputBitStream(outputBasename + ".index", bufferSize);
            OutputBitStream offsets = new OutputBitStream(outputBasename + ".offsets");
            OutputBitStream outputGlobCounts = new OutputBitStream(outputBasename + ".globcounts");
            OutputBitStream frequencies = new OutputBitStream(outputBasename + ".frequencies");
            PrintWriter termFile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputBasename + ".terms"), "UTF-8"), bufferSize));
            IndexWriter indexWriter = skips ? new SkipIndexWriter(mergedIndex, offsets, numberOfDocuments, writerFlags, quantum, height) : new IndexWriter(mergedIndex, offsets, numberOfDocuments, (long)writerFlags);
            boolean[] inIndex = new boolean[numIndices];
            int[] currIndex = new int[numIndices];
            int[] frequency = new int[numIndices];
            int[] position = new int[maxDocPos];
            long[] bitsForPointers = new long[10];
            long[] bitsForPositions = new long[10];
            long numPointers = 0L;
            long numOccurrences = 0L;
            long[] pointersByFrequency = new long[10];
            long[] occurrencesByFrequency = new long[10];
            pm.expectedUpdates(numberOfLists);
            pm.itemsName("lists");
            pm.start("Merging lists...");
            int numTerms = 0;
            while (!queue.isEmpty()) {
                int freqClass;
                k = 0;
                int n = k++;
                int n2 = queue.first();
                currIndex[n] = n2;
                j = n2;
                MutableString currTerm = ((MutableString)term[n2]).copy();
                inIndex[j] = true;
                currTerm.println(termFile);
                termReader[j].readWord((MutableString)term[j]);
                if (((MutableString)term[j]).length() == 0) {
                    queue.dequeue();
                } else {
                    queue.changed();
                }
                pm.update();
                while (!queue.isEmpty() && ((MutableString)term[queue.first()]).equals(currTerm)) {
                    int n3 = k++;
                    int n4 = queue.first();
                    currIndex[n3] = n4;
                    j = n4;
                    inIndex[j] = true;
                    termReader[j].readWord((MutableString)term[j]);
                    if (((MutableString)term[j]).length() == 0) {
                        queue.dequeue();
                    } else {
                        queue.changed();
                    }
                    pm.update();
                }
                ++numTerms;
                int totalFrequency = 0;
                long totalGlobCount = 0L;
                i = 0;
                while (i < k) {
                    int n5 = indexReader[currIndex[i]].readFrequency();
                    frequency[currIndex[i]] = n5;
                    totalFrequency += n5;
                    totalGlobCount += (long)globCounts[currIndex[i]].readGamma();
                    ++i;
                }
                indexWriter.newInvertedList();
                indexWriter.writeFrequency(totalFrequency);
                frequencies.writeGamma(totalFrequency);
                outputGlobCounts.writeLongGamma(totalGlobCount);
                int n6 = freqClass = (int)((double)(10 * totalFrequency) / (double)(numberOfDocuments + 1));
                occurrencesByFrequency[n6] = occurrencesByFrequency[n6] + totalGlobCount;
                numPointers += (long)totalFrequency;
                int n7 = freqClass;
                pointersByFrequency[n7] = pointersByFrequency[n7] + (long)totalFrequency;
                int numPrevDocs = 0;
                i = 0;
                while (i < numIndices) {
                    if (inIndex[i]) {
                        j = frequency[i];
                        while (j-- != 0) {
                            OutputBitStream obs = indexWriter.newDocumentRecord();
                            int currDoc = indexReader[i].readDocumentPointer() + numPrevDocs;
                            int n8 = freqClass;
                            bitsForPointers[n8] = bitsForPointers[n8] + (long)indexWriter.writeDocumentPointer(obs, currDoc);
                            if (!hasCounts) continue;
                            int count = indexReader[i].readPositionCount();
                            indexWriter.writePositionCount(obs, count);
                            numOccurrences += (long)count;
                            if (!hasPositions) continue;
                            indexReader[i].readDocumentPositions(position);
                            int n9 = freqClass;
                            bitsForPositions[n9] = bitsForPositions[n9] + (long)indexWriter.writeDocumentPositions(obs, position, 0, count, size[currDoc]);
                        }
                        inIndex[i] = false;
                    }
                    numPrevDocs += index[i].numberOfDocuments;
                    ++i;
                }
            }
            pm.done();
            indexWriter.close();
            offsets.close();
            frequencies.close();
            outputGlobCounts.close();
            termFile.close();
            Properties properties = new Properties();
            properties.setProperty("documents", String.valueOf(numberOfDocuments));
            properties.setProperty("maxdocpos", String.valueOf(maxDocPos));
            properties.setProperty("maxdocsize", String.valueOf(maxDocSize));
            properties.setProperty("compressionflags", writerFlagsString.toString());
            if (skips) {
                properties.setProperty("skipquantum", String.valueOf(quantum));
                properties.setProperty("skipheight", String.valueOf(height));
            }
            properties.setProperty("terms", String.valueOf(numTerms));
            properties.setProperty("indexclass", "it.unimi.dsi.mg4j.index." + (skips ? "SkipIndex" : "Index"));
            properties.setProperty("occurrences", String.valueOf(numOccurrences));
            FileOutputStream propertyFile = new FileOutputStream(outputBasename + ".properties");
            properties.store(propertyFile, "Merge properties");
            propertyFile.close();
            System.out.println("Number of documents: " + Fast.format(numberOfDocuments));
            System.out.println("Average size: " + Fast.format(averageSize));
            System.out.println("Number of terms: " + Fast.format(numTerms));
            System.out.println("Frequencies: " + Fast.format(indexWriter.bitsForFrequencies) + " bits, " + Fast.format((double)indexWriter.bitsForFrequencies / (double)numTerms) + " bits/frequency.");
            System.out.println("Document pointers: " + Fast.format(numPointers) + " (" + Fast.format(indexWriter.bitsForPointers) + " bits, " + Fast.format((double)indexWriter.bitsForPointers / (double)numPointers) + " bits/pointer).");
            if (indexWriter.hasCounts) {
                System.out.println("Counts: " + Fast.format(numPointers) + " (" + Fast.format(indexWriter.bitsForCounts) + " bits, " + Fast.format((double)indexWriter.bitsForCounts / (double)numPointers) + " bits/count).");
            }
            if (indexWriter.hasPositions) {
                System.out.println("Occurrences: " + Fast.format(numOccurrences) + " (" + Fast.format(indexWriter.bitsForPositions) + " bits, " + Fast.format((double)indexWriter.bitsForPositions / (double)numOccurrences) + " bits/occurrence).");
            }
            if (skips) {
                SkipIndexWriter s = (SkipIndexWriter)indexWriter;
                System.out.println("Skip towers: " + Fast.format(s.towerData.numberOfSkipTowers) + " (" + Fast.format(s.towerData.bitsForTowers()) + " bits [" + Fast.format((double)s.towerData.bitsForTowers() * 100.0 / (double)s.writtenBits()) + "%], " + Fast.format((double)s.towerData.bitsForTowers() / (double)s.towerData.numberOfSkipTowers) + " bits/tower)");
                System.out.println("Skip entries: " + Fast.format(s.towerData.numberOfSkipEntries) + " (" + Fast.format((double)s.towerData.bitsForEntries() / (double)s.towerData.numberOfSkipEntries) + " bits/entry)");
                System.out.println("Skip tower lengths: " + Fast.format(s.towerData.bitsForTowerLengths) + " bits (" + Fast.format((double)s.towerData.bitsForTowerLengths / (double)s.towerData.numberOfSkipTowers) + " bits/tower)");
                System.out.println("Quantum bit lengths: " + Fast.format(s.bitsForQuantumBitLengths) + " bits (" + Fast.format((double)s.bitsForQuantumBitLengths / (double)s.numberOfBlocks) + " bits/block)");
                System.out.println("Entry bit lengths: " + Fast.format(s.bitsForEntryBitLengths) + " bits (" + Fast.format((double)s.bitsForEntryBitLengths / (double)s.numberOfBlocks) + " bits/block)");
                System.out.println("Top skip amounts: " + Fast.format(s.towerData.bitsForTopSkipAmounts) + " bits (" + Fast.format((double)s.towerData.bitsForTopSkipAmounts / (double)s.towerData.numberOfSkipTowers) + " bits/amount)");
                System.out.println("Top skip pointers: " + Fast.format(s.towerData.bitsForTopSkipPointers) + " bits (" + Fast.format((double)s.towerData.bitsForTopSkipPointers / (double)s.towerData.numberOfSkipTowers) + " bits/pointer)");
                System.out.println("Lower skip amounts: " + Fast.format(s.towerData.bitsForLowerSkipAmounts) + " bits (" + Fast.format((double)s.towerData.bitsForLowerSkipAmounts / (double)s.towerData.numberOfLowerEntries()) + " bits/amount)");
                System.out.println("Lower skip pointers: " + Fast.format(s.towerData.bitsForLowerSkipPointers) + " bits (" + Fast.format((double)s.towerData.bitsForLowerSkipPointers / (double)s.towerData.numberOfLowerEntries()) + " bits/pointer)");
                System.out.println("Skip amounts: " + Fast.format(s.towerData.bitsForSkipAmounts()) + " bits (" + Fast.format((double)s.towerData.bitsForSkipAmounts() / (double)s.towerData.numberOfSkipEntries) + " bits/amount)");
                System.out.println("Skip pointers: " + Fast.format(s.towerData.bitsForSkipPointers()) + " bits (" + Fast.format((double)s.towerData.bitsForSkipPointers() / (double)s.towerData.numberOfSkipEntries) + " bits/pointer)");
            }
            System.out.println("Alignment: " + Fast.format(indexWriter.bitsForAlignment) + " bits, " + Fast.format((double)indexWriter.bitsForAlignment / (double)numTerms) + " bits/alignment.");
            if (indexWriter.hasPositions) {
                System.out.println("Total: " + Fast.format(indexWriter.writtenBits()) + " bits, " + Fast.format((double)indexWriter.writtenBits() / (double)numOccurrences) + " bits/occurrence");
            } else {
                System.out.println("Total: " + Fast.format(indexWriter.writtenBits()) + " bits, " + Fast.format((double)indexWriter.writtenBits() / (double)numOccurrences) + " bits/pointer");
            }
            System.out.println();
            System.out.println("Number of pointers by frequency:");
            i = 0;
            while (i < 10) {
                System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)pointersByFrequency[i] / (double)numPointers) + '%');
                ++i;
            }
            System.out.println();
            System.out.println("Number of occurrences by frequency:");
            i = 0;
            while (i < 10) {
                System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)occurrencesByFrequency[i] / (double)numOccurrences) + '%');
                ++i;
            }
            System.out.println();
            System.out.println("Number of bits for pointers by frequency:");
            i = 0;
            while (i < 10) {
                System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)bitsForPointers[i] / (double)indexWriter.bitsForPointers) + '%');
                ++i;
            }
            System.out.println();
            if (indexWriter.hasPositions) {
                System.out.println("Number of bits for occurrences by frequency:");
                i = 0;
                while (i < 10) {
                    System.out.println("<" + (i + 1) * 10 + "%: " + Fast.format(100.0 * (double)bitsForPositions[i] / (double)indexWriter.bitsForPositions) + '%');
                    ++i;
                }
            }
        }
        catch (IOException dontCare) {
            dontCare.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Merge() {
    }
}

