/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.score.LinearAggregator;
import it.unimi.dsi.mg4j.search.score.ScoredDocumentIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LinearAggregator {
    private static final boolean DEBUG = true;
    private int n;
    private boolean[] relevant;
    private double[] weight;

    public ScoredDocumentIterator aggregate(ScoredDocumentIterator[] underlying) {
        boolean over;
        if (underlying.length != this.n) {
            throw new IllegalArgumentException();
        }
        IntArrayList[] documents = new IntArrayList[this.n];
        DoubleArrayList[] scores = new DoubleArrayList[this.n];
        int i = 0;
        while (i < this.n) {
            documents[i] = new IntArrayList();
            scores[i] = new DoubleArrayList();
            ++i;
        }
        do {
            over = true;
            i = 0;
            while (i < this.n) {
                if (underlying[i].hasNext()) {
                    documents[i].add(underlying[i].nextDocument());
                    scores[i].add(underlying[i].score());
                    over = false;
                }
                ++i;
            }
        } while (!over);
        int j = 0;
        while (j < this.n) {
            System.err.println("Documents returned by iterator " + j + ": " + documents[j]);
            ++j;
        }
        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class MergedIterator
        extends AbstractIntIterator
        implements ScoredDocumentIterator {
            private int nextDocument;
            private int lastDocument;
            private double nextScore;
            private double lastScore;
            private int[] cursor;
            final /* synthetic */ LinearAggregator this$0;
            final /* synthetic */ IntArrayList[] val$documents;
            final /* synthetic */ DoubleArrayList[] val$scores;

            public boolean hasNext() {
                int minDoc;
                if (this.nextDocument >= 0) {
                    return true;
                }
                if (this.nextDocument == Integer.MAX_VALUE) {
                    return false;
                }
                double aggregateScore = 0.0;
                boolean isMinRelevant = false;
                do {
                    minDoc = Integer.MAX_VALUE;
                    int i = 0;
                    while (i < LinearAggregator.access$0(this.this$0)) {
                        if (this.cursor[i] < this.val$documents[i].size()) {
                            isMinRelevant |= LinearAggregator.access$1(this.this$0)[i];
                            int candidateMin = this.val$documents[i].getInt(this.cursor[i]);
                            if (candidateMin < minDoc) {
                                minDoc = candidateMin;
                                aggregateScore = LinearAggregator.access$2(this.this$0)[i] * this.val$scores[i].getDouble(this.cursor[i]);
                            } else if (candidateMin == minDoc) {
                                aggregateScore += LinearAggregator.access$2(this.this$0)[i] * this.val$scores[i].getDouble(this.cursor[i]);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < LinearAggregator.access$0(this.this$0)) {
                        if (this.cursor[i] < this.val$documents[i].size() && this.val$documents[i].getInt(this.cursor[i]) == minDoc) {
                            int n = i;
                            this.cursor[n] = this.cursor[n] + 1;
                        }
                        ++i;
                    }
                } while (!isMinRelevant && minDoc < Integer.MAX_VALUE);
                this.nextDocument = minDoc;
                this.nextScore = aggregateScore;
                boolean bl = false;
                if (this.nextDocument < Integer.MAX_VALUE) {
                    bl = true;
                }
                return bl;
            }

            public int nextDocument() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastDocument = this.nextDocument;
                this.lastScore = this.nextScore;
                this.nextDocument = -1;
                return this.lastDocument;
            }

            public int document() {
                if (this.lastDocument < 0) {
                    throw new IllegalStateException();
                }
                return this.lastDocument;
            }

            public double score() {
                if (this.lastDocument < 0) {
                    throw new IllegalStateException();
                }
                return this.lastScore;
            }

            public int skipTo(int n) {
                int k = 0;
                if (this.lastDocument >= n) {
                    return this.lastDocument;
                }
                while (this.hasNext() && (k = this.nextInt()) < n) {
                }
                return this.hasNext() ? k : -1;
            }

            public int nextInt() {
                return this.nextDocument();
            }

            public double score(Index index) {
                throw new UnsupportedOperationException();
            }

            public Map intervalIterators() {
                throw new UnsupportedOperationException();
            }

            public IntervalIterator intervalIterator() {
                throw new UnsupportedOperationException();
            }

            public IntervalIterator intervalIterator(Index index) {
                throw new UnsupportedOperationException();
            }

            public Set indices() {
                throw new UnsupportedOperationException();
            }

            private final /* synthetic */ void this() {
                this.nextDocument = -1;
                this.lastDocument = -1;
                this.nextScore = 0.0;
                this.lastScore = 0.0;
                this.cursor = new int[LinearAggregator.access$0(this.this$0)];
            }

            MergedIterator(LinearAggregator linearAggregator, IntArrayList[] intArrayListArray, DoubleArrayList[] doubleArrayListArray) {
                this.this$0 = linearAggregator;
                this.val$documents = intArrayListArray;
                this.val$scores = doubleArrayListArray;
                this.this();
            }
        }
        return new MergedIterator(this, documents, scores);
    }

    static /* synthetic */ int access$0(LinearAggregator linearAggregator) {
        return linearAggregator.n;
    }

    static /* synthetic */ boolean[] access$1(LinearAggregator linearAggregator) {
        return linearAggregator.relevant;
    }

    static /* synthetic */ double[] access$2(LinearAggregator linearAggregator) {
        return linearAggregator.weight;
    }

    public LinearAggregator(boolean[] relevant, double[] weight) {
        if (relevant.length != weight.length) {
            throw new IllegalArgumentException();
        }
        this.n = relevant.length;
        this.relevant = relevant;
        this.weight = weight;
    }
}

