/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.score.AbstractScorer;

public class ClarkeCormackScorer
extends AbstractScorer {
    private int h;
    private double alpha;

    protected double score(IntervalIterator it) {
        if (it == IntervalIterators.TRUE || it == IntervalIterators.FALSE) {
            return 0.0;
        }
        double result = 0.0;
        while (it.hasNext()) {
            int lt = it.nextInterval().length();
            if (lt < this.h) {
                result += 1.0;
                continue;
            }
            result += Math.pow((double)this.h / (double)lt, this.alpha);
        }
        return result;
    }

    public ClarkeCormackScorer(int h, double alpha) {
        this.h = h;
        this.alpha = alpha;
    }

    public ClarkeCormackScorer() {
        this.h = 16;
        this.alpha = 1.0;
    }
}

